/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.serializer;

import static org.mule.metadata.persistence.MetadataTypeConstants.ARRAY;
import static org.mule.metadata.persistence.MetadataTypeConstants.ITEM;

import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;

import java.io.IOException;
import java.util.Stack;

import com.google.gson.stream.JsonWriter;

/**
 * {@link TypeSerializer} for {@link ArrayType}
 *
 * @since 1.2.0, 1.1.7
 */
public class ArrayTypeSerializer extends AbstractComplexTypeSerializer<ArrayType> {

  private final TypeSerializer<MetadataType> delegate;

  ArrayTypeSerializer(TypeSerializer<MetadataType> delegate) {
    super(ARRAY);
    this.delegate = delegate;
  }

  @Override
  public void doSerialize(JsonWriter writer, ArrayType arrayType, Stack<MetadataType> typeStack) throws IOException {
    writer.name(ITEM);
    delegate.serialize(writer, arrayType.getType(), typeStack);
  }
}
