/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence;

import org.mule.metadata.api.model.MetadataType;

/**
 * {@link RuntimeException} that declares that an error occurred serializing or deserializing a {@link MetadataType} object.
 *
 * @since 1.0
 */
public final class MetadataSerializingException extends RuntimeException {

  private static final String UNEXPECTED_ERROR_OCCURRED_SERIALIZING = "Unexpected error occurred serializing ";

  public MetadataSerializingException(String message, Exception cause) {
    super(UNEXPECTED_ERROR_OCCURRED_SERIALIZING + message, cause);
  }

  public MetadataSerializingException(String message) {
    super(UNEXPECTED_ERROR_OCCURRED_SERIALIZING + message);
  }
}
