/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.reduced;


import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.BaseMetadataTypeGsonTypeAdapter;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;

import java.lang.reflect.Type;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;

/**
 * {@link Gson} {@link TypeAdapter<MetadataType>} that helps to serialize and deserialize
 * {@link MetadataType} objects, by using both {@link ReducedJsonMetadataTypeWriter} and
 * {@link ReducedJsonMetadataTypeLoader} to generate a light-weight JSON for better generation,
 * transportation and storage.
 * <p>
 * To use it, register it into {@link Gson} use the {@link GsonBuilder} and invoking
 * {@link GsonBuilder#registerTypeAdapter(Type type, Object typeAdapter)}, with {@link MetadataType} class as the
 * {@code type} parameter and an instance of {@link MetadataTypeGsonTypeAdapter} for the {@code typeAdapter} parameter.
 *
 * @since 1.2.0, 1.1.7
 */
public final class ReducedMetadataTypeGsonTypeAdapter extends BaseMetadataTypeGsonTypeAdapter {

  public ReducedMetadataTypeGsonTypeAdapter() {
    super(new ReducedJsonMetadataTypeWriter(), new ReducedJsonMetadataTypeLoader());
  }
}
