/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

import com.google.gson.JsonElement;

/**
 * Base contract for implementations that deserialize {@link MetadataType} objects
 * from a JSON file.
 *
 * @since 1.2.0, 1.1.7
 */
public interface SerializedMetadataTypeLoader extends TypeLoader {

  /**
   * Parses a {@link MetadataType} JSON representation and returns a new {@link MetadataType} instance.
   *
   * @param element {@link MetadataType} JSON representation as a {@link JsonElement}
   * @return {@link Optional} value of a {@link MetadataType}
   */
  Optional<MetadataType> load(JsonElement element);
}
