/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import static org.mule.metadata.persistence.deserializer.SerializerUtils.getAnnotations;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.SerializedMetadataTypeLoader;

import com.google.gson.JsonObject;

/**
 * Abstract class for {@link TypeDeserializer} which provides a default implementation of
 * {@link TypeDeserializer#buildType(JsonObject, BaseTypeBuilder, SerializedMetadataTypeLoader)} for simple {@link MetadataType}s
 * and shares common behavior between {@link TypeDeserializer}
 *
 * @since 1.0
 */
abstract class AbstractTypeDeserializer implements TypeDeserializer {

  final TypeBuilderSupplier<WithAnnotation> supplier;

  AbstractTypeDeserializer(TypeBuilderSupplier<WithAnnotation> supplier) {

    this.supplier = supplier;
  }

  @Override
  public TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader) {
    final WithAnnotation withAnnotation = supplier.get(baseBuilder);
    parseAnnotations(typeObject, withAnnotation);
    return (TypeBuilder) withAnnotation;
  }

  void parseAnnotations(JsonObject typeObject, WithAnnotation withAnnotation) {
    getAnnotations(typeObject).forEach(withAnnotation::with);
  }

}
