/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.serializer.TypeSerializerVisitor;

import java.io.IOException;

/**
 * {@link MetadataTypeWriter} implementation that serialize a full {@link MetadataType} structure to a matching JSON object.
 *
 * @since 1.0
 */
public class JsonMetadataTypeWriter extends AbstractJsonMetadataTypeWriter {

  private final ObjectTypeReferenceHandler referenceHandler;

  /**
   * Creates a new instance which serializes all types explicitly without handling references
   */
  public JsonMetadataTypeWriter() {
    this(new NullObjectTypeReferenceHandler());
  }

  /**
   * Creates a new instance which handles type references through the given {@code referenceHandler}
   *
   * @param referenceHandler an {@link ObjectTypeReferenceHandler}
   */
  public JsonMetadataTypeWriter(ObjectTypeReferenceHandler referenceHandler) {
    this.referenceHandler = referenceHandler;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void write(MetadataType type) throws IOException {
    type.accept(new TypeSerializerVisitor(writer, referenceHandler, typeStack, true));
  }

  @Override
  public JsonMetadataTypeWriter setPrettyPrint(boolean prettyPrint) {
    super.setPrettyPrint(prettyPrint);
    return this;
  }
}
