/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence;

import static java.util.Optional.empty;

import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ObjectType;

import java.util.Optional;

import com.google.gson.stream.JsonWriter;

/**
 * A null object implementation of {@link ObjectTypeReferenceHandler} which handles no reference.
 *
 * Take into account that according to the contract defined in {@link ObjectTypeReferenceHandler}, each time any of these methods
 * return {@link Optional#empty()} the invoker has the responsibility to resolve the type somehow else.
 *
 * @since 1.0
 */
public final class NullObjectTypeReferenceHandler implements ObjectTypeReferenceHandler {

  /**
   * {@inheritDoc}
   */
  @Override
  public Optional<String> writeReference(ObjectType type, JsonWriter writer) {
    return empty();
  }

  @Override
  public boolean shouldWriteReference(ObjectType type) {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Optional<TypeBuilder> readReference(String typeId) {
    return empty();
  }
}
