/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.serializer;

import static org.mule.metadata.persistence.MetadataTypeConstants.OF;
import static org.mule.metadata.persistence.MetadataTypeConstants.TUPLE;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.TupleType;

import java.io.IOException;
import java.util.Stack;

import com.google.gson.stream.JsonWriter;

/**
 * {@link TypeSerializer} for {@link TupleType}s.
 *
 * @since 1.2.0, 1.1.7
 */
public class TupleTypeSerializer extends AbstractComplexTypeSerializer<TupleType> {

  private final TypeSerializer<MetadataType> delegate;

  TupleTypeSerializer(TypeSerializer<MetadataType> delegate) {
    super(TUPLE);
    this.delegate = delegate;
  }

  @Override
  public void doSerialize(JsonWriter writer, TupleType tupleType, Stack<MetadataType> typeStack) throws IOException {
    writer.name(OF);
    writer.beginArray();
    tupleType.getTypes().forEach(type -> delegate.serialize(writer, type, typeStack));
    writer.endArray();
  }
}
