/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Metadata Model persistence layer.
 * 
 * @moduleGraph
 * @since 1.5
 */
module org.mule.runtime.metadata.model.persistence {
  
  requires org.mule.runtime.metadata.model.api;
  requires org.mule.runtime.metadata.model.json;
  requires org.mule.runtime.metadata.model.xml;
  requires org.mule.runtime.metadata.model.java;

  requires com.google.common;
  requires com.google.gson;

  exports org.mule.metadata.persistence.api;

  uses org.mule.metadata.persistence.api.TypeAnnotationSerializerExtender;
  uses org.mule.metadata.persistence.api.TypeAnnotationSerializerExtenderFallback;

  // Exposed to other related modules of the Mule Runtime, but internal to other users
  exports org.mule.metadata.persistence to
      org.mule.runtime.extensions.xml.support,
      org.mule.runtime.extensions.api.persistence,
      org.mule.runtime.metadata.model.persistence.test;
  exports org.mule.metadata.persistence.reduced to
      org.mule.runtime.extensions.api.persistence,
      org.mule.wsdl.parser,
      org.mule.runtime.metadata.model.persistence.test;
  exports org.mule.metadata.persistence.type.adapter to
      org.mule.runtime.extensions.api.persistence;
}
