/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence;

import org.mule.metadata.api.model.MetadataType;

/**
 * {@link RuntimeException} that declares that an error occurred serializing or deserializing a {@link MetadataType} object.
 *
 * @since 1.0
 */
public final class MetadataDeserializingException extends RuntimeException {

  private static final String ERROR = "Unexpected error occurred deserializing ";

  public MetadataDeserializingException(Exception cause) {
    super(ERROR, cause);
  }

  public MetadataDeserializingException(String message) {
    super(message);
  }
}
