/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.type.adapter;

import java.util.Optional;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

/**
 * {@link TypeAdapterFactory} implementation which creates {@link OptionalTypeAdapter} instances when a {@link Optional} object is
 * needed to be serialized or deserialized.
 *
 * @since 1.0
 */
public class OptionalTypeAdapterFactory implements TypeAdapterFactory {

  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (type.getRawType().isAssignableFrom(Optional.class)) {
      return (TypeAdapter<T>) new OptionalTypeAdapter(gson);
    }
    return null;
  }
}
