/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.api;


import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.persistence.JsonMetadataTypeWriter;

/**
 * Factory object to get a fresh instance of a {@link JsonMetadataTypeWriter}.
 *
 * @since 1.2
 */
public class JsonMetadataTypeWriterFactory {

  /**
   * @return a fresh {@link JsonMetadataTypeWriter}
   */
  public static TypeWriter create() {
    return new JsonMetadataTypeWriter();
  }

}
