/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;

class CatalogJsonMetadataTypeLoader
extends JsonMetadataTypeLoader {
    private JsonObject jsonCatalog;
    private Map<String, TypeBuilder> typeIdBuilderStack;

    CatalogJsonMetadataTypeLoader(ObjectTypeReferenceHandler referenceHandler, JsonObject jsonCatalog) {
        super(referenceHandler);
        this.jsonCatalog = jsonCatalog;
    }

    @Override
    public Optional<MetadataType> load(JsonElement jsonElement) {
        return this.load(jsonElement, new HashMap<String, TypeBuilder>()).map(TypeBuilder::build);
    }

    public Optional<TypeBuilder> load(JsonElement jsonElement, Map<String, TypeBuilder> stack) {
        this.typeIdBuilderStack = stack;
        return super.load(jsonElement, new Stack<TypeBuilder>(), new Stack<MetadataFormat>());
    }

    @Override
    public TypeBuilder buildType(JsonElement metadataType, BaseTypeBuilder baseBuilder) {
        Optional<String> foundId = this.findId(metadataType);
        foundId.ifPresent(id -> this.typeIdBuilderStack.put((String)id, (TypeBuilder)baseBuilder));
        TypeBuilder typeBuilder = super.buildType(metadataType, baseBuilder);
        foundId.ifPresent(id -> this.typeIdBuilderStack.remove(id));
        return typeBuilder;
    }

    private Optional<String> findId(JsonElement element) {
        return this.jsonCatalog.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).equals(element)).map(entry -> (String)entry.getKey()).findFirst();
    }
}

