/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.serializer;

import static org.mule.metadata.persistence.MetadataTypeConstants.INTERSECTION;
import static org.mule.metadata.persistence.MetadataTypeConstants.OF;

import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;

import java.io.IOException;
import java.util.Stack;

import com.google.gson.stream.JsonWriter;

/**
 * {@link TypeSerializer} for {@link IntersectionType}s
 *
 * @since 1.2.0, 1.1.7
 */
public class IntersectionTypeSerializer extends AbstractComplexTypeSerializer<IntersectionType> {

  private final TypeSerializer<MetadataType> delegate;

  IntersectionTypeSerializer(TypeSerializer<MetadataType> delegate) {
    super(INTERSECTION);
    this.delegate = delegate;
  }

  @Override
  public void doSerialize(JsonWriter writer, IntersectionType intersectionType,
                          Stack<MetadataType> typeStack)
      throws IOException {
    writer.name(OF);
    writer.beginArray();
    intersectionType.getTypes().forEach(type -> delegate.serialize(writer, type, typeStack));
    writer.endArray();
  }
}
