/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.serializer;

import static org.mule.metadata.persistence.MetadataTypeConstants.OF;
import static org.mule.metadata.persistence.MetadataTypeConstants.UNION;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;

import java.io.IOException;
import java.util.Stack;

import com.google.gson.stream.JsonWriter;

/**
 * {@link TypeSerializer} for {@link UnionType}
 *
 * @since 1.2.0, 1.1.7
 */
public class UnionTypeSerializer extends AbstractComplexTypeSerializer<UnionType> {

  private final TypeSerializer<MetadataType> delegate;

  UnionTypeSerializer(TypeSerializer<MetadataType> jsonMetadataTypeWriter) {
    super(UNION);
    this.delegate = jsonMetadataTypeWriter;
  }

  @Override
  public void doSerialize(JsonWriter writer, UnionType unionType, Stack<MetadataType> typeStack) throws IOException {
    writer.name(OF);
    writer.beginArray();
    unionType.getTypes().forEach(type -> delegate.serialize(writer, type, typeStack));
    writer.endArray();
  }
}
