/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.raml.internal.util;


import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.common.ValidationResult;

import java.io.File;

public class RamlLoaderUtils {

  public static RamlModelResult buildApiOrFail(File ramlFile) {
    final RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi(ramlFile);
    assertRamlModelResult(ramlModelResult, ramlFile.getPath());
    return ramlModelResult;
  }

  public static RamlModelResult buildApiOrFail(String content, String ramlLocation) {
    final RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi(content, ramlLocation);
    assertRamlModelResult(ramlModelResult, ramlLocation);
    return ramlModelResult;
  }

  private static void assertRamlModelResult(RamlModelResult ramlModelResult, String ramlLocation) {
    if (ramlModelResult.hasErrors()) {
      StringBuilder sb = new StringBuilder(String.format("There are [%d] errors in the RAML [%s]. Full list:",
                                                         ramlModelResult.getValidationResults().size(), ramlLocation));
      for (ValidationResult validationResult : ramlModelResult.getValidationResults()) {
        sb.append(String.format("\nMessage:[%s]. Path:[%s]", validationResult.getMessage(), validationResult.getPath()));
      }
      throw new IllegalArgumentException(sb.toString());
    }
  }
}
