/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.raml.internal.fragments;

import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import java.util.Optional;

public abstract class AbstractTypeDeclarationLoader {

  final RamlModelResult ramlModelResult;

  AbstractTypeDeclarationLoader(RamlModelResult ramlModelResult) {
    this.ramlModelResult = ramlModelResult;
  }

  public abstract Optional<TypeDeclaration> load(String typeIdentifier);
}
