/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.raml.api;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.raml.internal.RamlTypeLoader;
import org.mule.metadata.raml.internal.TypeDeclarationTypeLoader;

import java.io.File;
import java.util.Optional;

import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

/**
 * RAML {@link TypeLoader} that takes the internal {@link TypeDeclaration} and transforms it into a {@link MetadataType} through
 * {@link TypeDeclaration#toJsonSchema()} in conjunction with {@link JsonTypeLoader}.
 * <p/>
 * Supported fragments so far: {@link RamlFragment#DataType} and {@link RamlFragment#Library}, any other will fail while loading t
 * he RAML file
 *
 * @since 1.0
 */
public class JsonRamlTypeLoader implements TypeLoader {

  private final RamlTypeLoader ramlTypeLoader;

  /**
   * Constructs a RAML type loader
   *
   * @param ramlFile file pointing to the RAML resource
   */
  public JsonRamlTypeLoader(File ramlFile) {
    this.ramlTypeLoader = new RamlTypeLoader(ramlFile, createJsonTypeDeclarationTypeLoader());
  }

  /**
   * Constructs a RAML type loader
   *
   * @param content content of the RAML resource
   * @param ramlLocation pointer to the RAML location
   */
  public JsonRamlTypeLoader(String content, String ramlLocation) {
    this.ramlTypeLoader = new RamlTypeLoader(content, ramlLocation, createJsonTypeDeclarationTypeLoader());
  }

  private TypeDeclarationTypeLoader createJsonTypeDeclarationTypeLoader() {
    return (typeDeclaration, typeIdentifier, typeAlias) -> new JsonTypeLoader(typeDeclaration.toJsonSchema())
        .load(typeIdentifier, typeAlias);
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier) {
    return load(typeIdentifier, null);
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    return ramlTypeLoader.load(typeIdentifier, typeAlias);
  }
}
