/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.raml.internal;

import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.raml.internal.fragments.handler.ParsingContext;
import org.mule.metadata.raml.internal.fragments.handler.TypeDeclarationHandlerManager;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import java.util.Optional;

public class CustomHandlingTypeDeclarationTypeLoader implements TypeDeclarationTypeLoader {

  private MetadataFormat metadataFormat;

  public CustomHandlingTypeDeclarationTypeLoader(MetadataFormat metadataFormat) {
    this.metadataFormat = metadataFormat;
  }

  @Override
  public Optional<MetadataType> load(TypeDeclaration typeDeclaration, String typeIdentifier, String typeAlias) {
    final TypeDeclarationHandlerManager typeDeclarationHandlerManager = new TypeDeclarationHandlerManager(metadataFormat);
    final TypeBuilder<?> typeBuilder = typeDeclarationHandlerManager.handle(typeDeclaration, new ParsingContext());
    MetadataTypeUtils.addTypeAlias(typeBuilder, typeAlias);
    return Optional.of(typeBuilder.build());
  }
}
