/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.raml.internal.fragments;

import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.api.Library;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import java.util.List;
import java.util.Optional;

public class LibraryTypeDeclarationLoader extends AbstractTypeDeclarationLoader {

  public LibraryTypeDeclarationLoader(RamlModelResult ramlModelResult) {
    super(ramlModelResult);
  }

  @Override
  public Optional<TypeDeclaration> load(String typeIdentifier) {
    final Library library = ramlModelResult.getLibrary();
    final List<TypeDeclaration> types = library.types();
    return types.stream()
        .filter(typeDeclaration -> typeDeclaration.name().equals(typeIdentifier))
        .findFirst();
  }
}
