/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.raml.internal.fragments.handler;

import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import java.util.Optional;

public class ArrayTypeDeclarationHandler implements TypeDeclarationHandler {

  @Override
  public boolean handles(TypeDeclaration typeDeclaration) {
    return typeDeclaration instanceof ArrayTypeDeclaration;
  }

  @Override
  public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root,
                               TypeDeclarationHandlerManager typeDeclarationHandlerManager,
                               ParsingContext parsingContext) {
    ArrayTypeDeclaration arrayTypeDeclaration = (ArrayTypeDeclaration) typeDeclaration;

    final ArrayTypeBuilder arrayTypeBuilder = root.arrayType();
    arrayTypeBuilder.of(typeDeclarationHandlerManager.handle(arrayTypeDeclaration.items(), parsingContext));


    final Optional<Integer> maxItems = Optional.ofNullable(arrayTypeDeclaration.maxItems());
    final Optional<Integer> minItems = Optional.ofNullable(arrayTypeDeclaration.minItems());
    if (maxItems.isPresent() && minItems.isPresent()) {
      arrayTypeBuilder.boundary(minItems.get(), maxItems.get());
    }

    final Optional<Boolean> uniqueItems = Optional.ofNullable(arrayTypeDeclaration.uniqueItems());
    if (uniqueItems.isPresent()) {
      arrayTypeBuilder.uniques();
    }

    return arrayTypeBuilder;
  }
}
