/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.xml.api.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.DateTimeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.xml.api.utils.XmlConstants;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import javax.xml.namespace.QName;

import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;

public class DateTimeHandler implements XmlHandler {

  public static final List<QName> DATE_TIME_TYPES = Arrays.asList(XmlConstants.XSD_DATETIME);

  @Override
  public boolean handles(QName schema) {
    return DATE_TIME_TYPES.contains(schema);
  }

  @Override
  public TypeBuilder<?> handle(XSSimpleTypeDecl xsTypeDefinition, Optional<String> defaultValue, BaseTypeBuilder builder) {
    final DateTimeBuilder dateTimeType = builder.dateTimeType();

    if (defaultValue.isPresent() && !defaultValue.get().isEmpty()) {
      dateTimeType.defaultValue(defaultValue.get());
    }
    return dateTimeType;
  }
}
