/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.xml.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TimeTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.xml.utils.XmlConstants;

import com.sun.org.apache.xerces.internal.impl.dv.xs.XSSimpleTypeDecl;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import javax.xml.namespace.QName;

public class TimeHandler implements XmlHandler {

  public static final List<QName> TIME_TYPES = Arrays.asList(XmlConstants.XSD_TIME);

  @Override
  public boolean handles(QName schema) {
    return TIME_TYPES.contains(schema);
  }

  @Override
  public TypeBuilder<?> handle(XSSimpleTypeDecl xsTypeDefinition, Optional<String> defaultValue, BaseTypeBuilder builder) {
    final TimeTypeBuilder dateTimeType = builder.timeType();

    if (defaultValue.isPresent() && !defaultValue.get().isEmpty()) {
      dateTimeType.defaultValue(defaultValue.get());
    }
    return dateTimeType;
  }
}
