/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.xml.internal;

import org.mule.apache.xerces.dom.DOMInputImpl;
import org.mule.metadata.internal.utils.StringUtils;

import java.util.Map;

import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ResourceResolver implements LSResourceResolver {

  private Map<String, DOMInputImpl> schemaByTargetNamespace;

  public ResourceResolver(Map<String, DOMInputImpl> schemaByTargetNamespace) {
    this.schemaByTargetNamespace = schemaByTargetNamespace;
  }

  @Override
  public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
    if (StringUtils.isNotEmpty(namespaceURI) && publicId == null && systemId == null) {
      if (schemaByTargetNamespace.containsKey(namespaceURI)) {
        return schemaByTargetNamespace.get(namespaceURI);
      }
    }
    return null;
  }
}
