/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.xml.api.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.Optional;

import javax.xml.namespace.QName;

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;

public interface XmlHandler {

  boolean handles(QName schema);

  TypeBuilder<?> handle(XSSimpleTypeDecl xsTypeDefinition, Optional<String> defaultValue, BaseTypeBuilder builder);
}
