/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.xml.api.handler;

import static java.util.Collections.singletonList;
import static org.mule.metadata.xml.api.utils.XmlConstants.XSD_DATE;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.DateTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;

import java.util.List;
import java.util.Optional;

import javax.xml.namespace.QName;

public class DateHandler implements XmlHandler {

  public static final List<QName> DATE_TYPES = singletonList(XSD_DATE);

  @Override
  public boolean handles(QName schema) {
    return DATE_TYPES.contains(schema);
  }

  @Override
  public TypeBuilder<?> handle(XSSimpleTypeDecl xsTypeDefinition, Optional<String> defaultValue, BaseTypeBuilder builder) {
    final DateTypeBuilder dateType = builder.dateType();

    if (defaultValue.isPresent() && !defaultValue.get().isEmpty()) {
      dateType.defaultValue(defaultValue.get());
    }
    return dateType;
  }
}
