/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.xml.internal.utils;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class DocumentBuilderUtils {

  private final static DocumentBuilderFactory DOC_BUILDER_FACTORY;

  static {
    final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    // Disable external entities
    try {
      factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
      factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
    } catch (final ParserConfigurationException e) {
      throw new RuntimeException(e);
    }

    DOC_BUILDER_FACTORY = factory;
  }

  public static DocumentBuilderFactory getDocumentBuilderFactory() {
    return DOC_BUILDER_FACTORY;
  }
}
