/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.xml.internal.utils;

import static org.mule.apache.xerces.xs.XSSimpleTypeDefinition.FACET_ENUMERATION;
import static org.mule.apache.xerces.xs.XSSimpleTypeDefinition.FACET_PATTERN;

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.apache.xerces.xs.XSAttributeUse;
import org.mule.apache.xerces.xs.XSElementDeclaration;
import org.mule.apache.xerces.xs.XSFacet;
import org.mule.apache.xerces.xs.XSMultiValueFacet;
import org.mule.apache.xerces.xs.XSObject;
import org.mule.apache.xerces.xs.XSObjectList;

import java.util.Optional;

/**
 * Provides utilities to work with XML schemas
 *
 * @since 1.1
 */
public class SchemaHelper {

  public static Optional<String> getDefaultValue(XSElementDeclaration element) {
    return Optional.ofNullable(element.getConstraintValue());
  }

  public static Optional<String> getDefaultValue(XSAttributeUse attributeDeclaration) {
    return Optional.ofNullable(attributeDeclaration.getConstraintValue());
  }

  public static Integer getIntegerValue(XSObject patternFacetObject) {
    final XSFacet minLengthFacet = (XSFacet) patternFacetObject;
    final String lexicalFacetValues = minLengthFacet.getLexicalFacetValue();
    if (lexicalFacetValues != null && !lexicalFacetValues.isEmpty()) {
      return Integer.parseInt(lexicalFacetValues);
    }
    return -1;
  }

  public static Double getDoubleValue(XSObject patternFacetObject) {
    final XSFacet minLengthFacet = (XSFacet) patternFacetObject;
    final String lexicalFacetValues = minLengthFacet.getLexicalFacetValue();
    if (lexicalFacetValues != null && !lexicalFacetValues.isEmpty()) {
      return Double.parseDouble(lexicalFacetValues);
    }
    return 1D;
  }

  public static XSObject getFacet(XSSimpleTypeDecl element, int facetType) {
    if (facetType == FACET_ENUMERATION || facetType == FACET_PATTERN) {
      XSObjectList list = element.getMultiValueFacets();
      for (int i = 0; i < list.getLength(); i++) {
        XSMultiValueFacet f = (XSMultiValueFacet) list.item(i);
        if (f.getFacetKind() == facetType) {
          return f;
        }
      }
    } else {
      XSObjectList list = element.getFacets();
      for (int i = 0; i < list.getLength(); i++) {
        XSFacet f = (XSFacet) list.item(i);
        if (f.getFacetKind() == facetType) {
          return f;
        }
      }
    }
    return null;
  }

}
