/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl.instrument;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.metrics.api.instrument.LongCounter;
import org.mule.runtime.metrics.api.instrument.builder.LongCounterBuilder;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.impl.instrument.repository.InstrumentRepository;

public class DefaultLongCounter
implements LongCounter {
    private final AtomicLong value = new AtomicLong(0L);
    private final String name;
    private final String description;
    private final String unit;
    private final Meter meter;
    private Supplier<Long> valueSupplier = this.value::get;
    private Consumer<Long> addOperation = this.value::addAndGet;
    private Supplier<Long> incrementAndGetOperation = this.value::incrementAndGet;

    public static DefaultLongCounterBuilder builder(String name, Meter meter) {
        return new DefaultLongCounterBuilder(name, meter);
    }

    private DefaultLongCounter(String name, String description, String unit, Meter meter) {
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.meter = meter;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Meter getMeter() {
        return this.meter;
    }

    public void add(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("The value to add must be positive");
        }
        this.addOperation.accept(value);
    }

    public long getValueAsLong() {
        return this.valueSupplier.get();
    }

    public String getUnit() {
        return this.unit;
    }

    public int getValueAsInt() {
        return this.valueSupplier.get().intValue();
    }

    public int incrementAndGetAsInt() {
        return this.incrementAndGetOperation.get().intValue();
    }

    public long incrementAndGetAsLong() {
        return this.incrementAndGetOperation.get();
    }

    public void reset() {
        this.value.set(0L);
    }

    private void setIncrementAndGetOperation(Supplier<Long> incrementAndGetOperation) {
        this.incrementAndGetOperation = incrementAndGetOperation;
    }

    private void setAddOperation(Consumer<Long> addOperation) {
        this.addOperation = addOperation;
    }

    private void setValueSupplier(Supplier<Long> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    public static class DefaultLongCounterBuilder
    implements LongCounterBuilder {
        private final String name;
        private final Meter meter;
        private InstrumentRepository instrumentRepository;
        private String description;
        private String unit;
        private MeterExporter meterExporter;
        private Consumer<Long> addOperation;
        private Supplier<Long> incrementAndGetOperation;
        private Supplier<Long> valueSupplier;

        public DefaultLongCounterBuilder(String name, Meter meter) {
            this.name = name;
            this.meter = meter;
        }

        public DefaultLongCounterBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public DefaultLongCounterBuilder withUnit(String unit) {
            this.unit = unit;
            return this;
        }

        public DefaultLongCounterBuilder withInstrumentRepository(InstrumentRepository instrumentRepository) {
            this.instrumentRepository = instrumentRepository;
            return this;
        }

        public DefaultLongCounterBuilder withMeterExporter(MeterExporter meterExporter) {
            this.meterExporter = meterExporter;
            return this;
        }

        public LongCounter build() {
            LongCounter longCounter = Optional.ofNullable(this.instrumentRepository).map(repository -> (LongCounter)repository.create(this.name, name -> this.doBuild())).orElse(this.doBuild());
            if (this.meterExporter != null) {
                this.meterExporter.enableExport(longCounter);
            }
            return longCounter;
        }

        private LongCounter doBuild() {
            DefaultLongCounter longCounter = new DefaultLongCounter(this.name, this.description, this.unit, this.meter);
            if (this.valueSupplier != null) {
                longCounter.setValueSupplier(this.valueSupplier);
            }
            if (this.addOperation != null) {
                longCounter.setAddOperation(this.addOperation);
            }
            if (this.incrementAndGetOperation != null) {
                longCounter.setIncrementAndGetOperation(this.incrementAndGetOperation);
            }
            return longCounter;
        }

        public DefaultLongCounterBuilder withConsumerForAddOperation(Consumer<Long> consumerForAddOperation) {
            this.addOperation = consumerForAddOperation;
            return this;
        }

        public DefaultLongCounterBuilder withSupplierForIncrementAndGetOperation(Supplier<Long> supplierForIncrementOperation) {
            this.incrementAndGetOperation = supplierForIncrementOperation;
            return this;
        }

        public DefaultLongCounterBuilder withValueSupplier(Supplier<Long> valueSupplier) {
            this.valueSupplier = valueSupplier;
            return this;
        }
    }
}

