/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

import static org.mule.runtime.api.util.MuleSystemProperties.SYSTEM_PROPERTY_PREFIX;

import static java.lang.Boolean.parseBoolean;
import static java.lang.System.getProperty;

import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

/**
 * Makes sure all native library dependencies of a given native library are loaded.
 */
public interface NativeLibraryDependenciesLoader {

  void loadNativeLibraryDependencies(String nativeLibraryName);

  /**
   * Factory to decide which implementation to use. Implements the null-object pattern for when no preloading is needed.
   */
  class Factory {

    private static final String PRE_LOAD_NATIVE_LIBRARY_DEPENDENCIES =
        SYSTEM_PROPERTY_PREFIX + "native.library.dependencies.preload";

    NativeLibraryDependenciesLoader create(ArtifactDescriptor artifactDescriptor,
                                           NativeLibraryFinder nativeLibraryFinder,
                                           ClassLoader artifactClassLoader) {
      if (parseBoolean(getProperty(PRE_LOAD_NATIVE_LIBRARY_DEPENDENCIES, "true"))) {
        return new IsolatedNativeLibraryDependenciesLoader(artifactDescriptor, nativeLibraryFinder, artifactClassLoader);
      } else {
        // No-op loader
        return nativeLibraryName -> {
        };
      }
    }
  }
}
