/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleApplicationClassLoader;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.activation.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ChildOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.DelegateOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="Classloading Isolation")
@Story(value="ClassLoader generation")
public class DefaultArtifactClassLoaderResolverTestCase
extends AbstractMuleTestCase {
    public static final String MULE_DOMAIN_FOLDER = "domains";
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public TemporaryFolder artifactLocation = new TemporaryFolder();
    @Rule
    public final SystemProperty muleHomeSystemProperty = new SystemProperty("mule.home", temporaryFolder.getRoot().getCanonicalPath());
    private final File muleHomeFolder;
    private DefaultArtifactClassLoaderResolver artifactClassLoaderResolver;
    private final ModuleRepository moduleRepository = (ModuleRepository)Mockito.mock(ModuleRepository.class);
    private final DefaultNativeLibraryFinderFactory nativeLibraryFinderFactory = new DefaultNativeLibraryFinderFactory();
    private static final String PRIVILEGED_PACKAGE = "org.foo.privileged";
    private static final String GROUP_ID = "org.mule.test";
    private static final String PLUGIN_ID1 = "plugin1";
    private static final String PLUGIN_ARTIFACT_ID1 = "org.mule.test:plugin1";
    private static final String PLUGIN_ID2 = "plugin2";
    private static final BundleDescriptor PLUGIN1_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId("plugin1").setVersion("1.0").setClassifier("mule-plugin").build();
    private static final BundleDescriptor PLUGIN2_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId("plugin2").setVersion("1.0").setClassifier("mule-plugin").build();
    private final ArtifactPluginDescriptor plugin1Descriptor = new ArtifactPluginDescriptor("plugin1");
    private final ArtifactPluginDescriptor plugin2Descriptor = new ArtifactPluginDescriptor("plugin2");

    public DefaultArtifactClassLoaderResolverTestCase() throws IOException {
        this.muleHomeFolder = temporaryFolder.getRoot();
    }

    @Before
    public void setup() {
        this.artifactClassLoaderResolver = (DefaultArtifactClassLoaderResolver)Mockito.spy((Object)new DefaultArtifactClassLoaderResolver(this.moduleRepository, (NativeLibraryFinderFactory)this.nativeLibraryFinderFactory));
        this.plugin1Descriptor.setBundleDescriptor(PLUGIN1_BUNDLE_DESCRIPTOR);
        this.plugin2Descriptor.setBundleDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR);
    }

    @After
    public void tearDown() {
        this.deleteIfNeeded(MuleFoldersUtil.getDomainsFolder());
        this.deleteIfNeeded(new File(MuleFoldersUtil.getMuleLibFolder(), "shared"));
    }

    private void deleteIfNeeded(File file) {
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    @Test
    public void createDomainDefaultClassLoader() {
        DomainDescriptor descriptor = this.getTestDomainDescriptor("default");
        String artifactId = DefaultArtifactClassLoaderResolver.getDomainId((String)"default");
        MuleDeployableArtifactClassLoader domainClassLoader = this.artifactClassLoaderResolver.createDomainClassLoader(descriptor);
        MatcherAssert.assertThat((Object)domainClassLoader.getClassLoader(), (Matcher)CoreMatchers.instanceOf(MuleSharedDomainClassLoader.class));
        MatcherAssert.assertThat((Object)domainClassLoader.getArtifactId(), (Matcher)CoreMatchers.equalTo((Object)artifactId));
    }

    @Test
    public void createDomainCustomClassLoader() {
        String domainName = "custom-domain";
        DomainDescriptor descriptor = this.getTestDomainDescriptor("custom-domain");
        String artifactId = DefaultArtifactClassLoaderResolver.getDomainId((String)"custom-domain");
        descriptor.setRootFolder(this.createDomainDir(MULE_DOMAIN_FOLDER, "custom-domain"));
        MuleDeployableArtifactClassLoader domainClassLoader = this.artifactClassLoaderResolver.createDomainClassLoader(descriptor);
        MatcherAssert.assertThat((Object)domainClassLoader.getClassLoader(), (Matcher)CoreMatchers.instanceOf(MuleSharedDomainClassLoader.class));
        MatcherAssert.assertThat((Object)domainClassLoader.getArtifactId(), (Matcher)CoreMatchers.equalTo((Object)artifactId));
    }

    @Test(expected=ArtifactActivationException.class)
    public void validateDomainBeforeCreatingClassLoader() {
        DomainDescriptor descriptor = this.getTestDomainDescriptor("some-domain");
        descriptor.setRootFolder(new File("non-existent"));
        this.artifactClassLoaderResolver.createDomainClassLoader(descriptor);
    }

    @Test
    public void createDomainClassLoaderWithExportedPackages() {
        MuleModule muleModule = (MuleModule)Mockito.mock(MuleModule.class);
        String repeatedPackageName = "module&domain-package";
        Mockito.when((Object)muleModule.getExportedPackages()).thenReturn(Collections.singleton("module&domain-package"));
        Mockito.when((Object)this.moduleRepository.getModules()).thenReturn(Collections.singletonList(muleModule));
        String onlyDomainPackageName = "domain-package";
        MuleDeployableArtifactClassLoader domainClassLoader = this.getTestDomainClassLoader(Collections.emptyList(), Stream.of("domain-package", "module&domain-package").collect(Collectors.toSet()));
        RegionClassLoader regionClassLoader = (RegionClassLoader)domainClassLoader.getParent();
        MatcherAssert.assertThat((Object)domainClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy("module&domain-package"), (Matcher)CoreMatchers.instanceOf(ContainerOnlyLookupStrategy.class));
        MatcherAssert.assertThat((Object)regionClassLoader.filterForClassLoader(regionClassLoader.getOwnerClassLoader()).exportsPackage("module&domain-package"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)regionClassLoader.filterForClassLoader(regionClassLoader.getOwnerClassLoader()).exportsPackage("domain-package"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void createDomainClassLoaderWithPlugins() {
        MuleDeployableArtifactClassLoader domainClassLoader = this.getTestDomainClassLoader(Stream.of(this.plugin1Descriptor, this.plugin2Descriptor).collect(Collectors.toList()));
        RegionClassLoader regionClassLoader = (RegionClassLoader)domainClassLoader.getParent();
        MatcherAssert.assertThat(regionClassLoader.getArtifactPluginClassLoaders().stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{this.plugin1Descriptor, this.plugin2Descriptor}));
    }

    @Test
    public void createDomainClassLoaderWithCachedPlugin() {
        MuleDeployableArtifactClassLoader domainClassLoader = this.getTestDomainClassLoader(Collections.emptyList());
        DomainDescriptor newDomainDescriptor = (DomainDescriptor)domainClassLoader.getArtifactDescriptor();
        newDomainDescriptor.setPlugins(Stream.of(this.plugin1Descriptor, this.plugin2Descriptor).collect(Collectors.toSet()));
        MuleArtifactClassLoader plugin2ClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(domainClassLoader, this.plugin2Descriptor, d -> Optional.empty());
        domainClassLoader = this.artifactClassLoaderResolver.createDomainClassLoader(newDomainDescriptor, (ownerClassLoader, pluginDescriptor) -> {
            if (pluginDescriptor.getBundleDescriptor().getArtifactId().equals(this.plugin2Descriptor.getBundleDescriptor().getArtifactId())) {
                return Optional.of(() -> plugin2ClassLoader);
            }
            return Optional.empty();
        });
        ((DefaultArtifactClassLoaderResolver)Mockito.verify((Object)this.artifactClassLoaderResolver, (VerificationMode)Mockito.times((int)1))).createMulePluginClassLoader((MuleDeployableArtifactClassLoader)Mockito.any(), (ArtifactPluginDescriptor)Mockito.eq((Object)this.plugin2Descriptor), (PluginDescriptorResolver)Mockito.any());
        RegionClassLoader regionClassLoader = (RegionClassLoader)domainClassLoader.getParent();
        MatcherAssert.assertThat(regionClassLoader.getArtifactPluginClassLoaders().stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{this.plugin1Descriptor, this.plugin2Descriptor}));
    }

    @Test
    public void createApplicationClassLoader() {
        String applicationName = "app";
        MuleDeployableArtifactClassLoader domainClassLoader = this.getTestDomainClassLoader(Collections.emptyList());
        String artifactId = DefaultArtifactClassLoaderResolver.getApplicationId((String)domainClassLoader.getArtifactId(), (String)"app");
        ApplicationDescriptor descriptor = new ApplicationDescriptor("app");
        descriptor.setArtifactLocation(new File(this.muleHomeFolder, "app"));
        MuleDeployableArtifactClassLoader artifactClassLoader = this.artifactClassLoaderResolver.createApplicationClassLoader(descriptor, () -> domainClassLoader);
        MatcherAssert.assertThat((Object)artifactClassLoader.getClassLoader(), (Matcher)CoreMatchers.instanceOf(MuleApplicationClassLoader.class));
        MuleApplicationClassLoader applicationClassLoader = (MuleApplicationClassLoader)artifactClassLoader;
        MatcherAssert.assertThat((Object)applicationClassLoader.getParent().getParent(), (Matcher)Is.is((Object)domainClassLoader.getClassLoader()));
        MatcherAssert.assertThat((Object)applicationClassLoader.getArtifactId(), (Matcher)Is.is((Object)artifactId));
    }

    @Test
    public void createApplicationClassLoaderWithExportedPackages() {
        MuleModule muleModule = (MuleModule)Mockito.mock(MuleModule.class);
        String repeatedPackageName = "module&app-package";
        Mockito.when((Object)muleModule.getExportedPackages()).thenReturn(Collections.singleton("module&app-package"));
        Mockito.when((Object)this.moduleRepository.getModules()).thenReturn(Collections.singletonList(muleModule));
        String onlyAppPackageName = "app-package";
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Collections.emptyList(), Stream.of("app-package", "module&app-package").collect(Collectors.toSet()));
        RegionClassLoader regionClassLoader = (RegionClassLoader)applicationClassLoader.getParent();
        MatcherAssert.assertThat((Object)applicationClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy("module&app-package"), (Matcher)CoreMatchers.instanceOf(ContainerOnlyLookupStrategy.class));
        MatcherAssert.assertThat((Object)regionClassLoader.filterForClassLoader(regionClassLoader.getOwnerClassLoader()).exportsPackage("module&app-package"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)regionClassLoader.filterForClassLoader(regionClassLoader.getOwnerClassLoader()).exportsPackage("app-package"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void createApplicationClassLoaderWithPlugins() {
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Stream.of(this.plugin1Descriptor, this.plugin2Descriptor).collect(Collectors.toList()));
        RegionClassLoader regionClassLoader = (RegionClassLoader)applicationClassLoader.getParent();
        MatcherAssert.assertThat(regionClassLoader.getArtifactPluginClassLoaders().stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{this.plugin1Descriptor, this.plugin2Descriptor}));
    }

    @Test
    public void createApplicationClassLoaderWithCachedPlugin() {
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Collections.emptyList());
        ApplicationDescriptor newApplicationDescriptor = (ApplicationDescriptor)applicationClassLoader.getArtifactDescriptor();
        newApplicationDescriptor.setPlugins(Stream.of(this.plugin1Descriptor, this.plugin2Descriptor).collect(Collectors.toSet()));
        MuleArtifactClassLoader domainClassLoader = (MuleArtifactClassLoader)applicationClassLoader.getParent().getParent();
        MuleArtifactClassLoader plugin2ClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(applicationClassLoader, this.plugin2Descriptor, d -> Optional.empty());
        applicationClassLoader = this.artifactClassLoaderResolver.createApplicationClassLoader(newApplicationDescriptor, () -> domainClassLoader, (ownerClassLoader, pluginDescriptor) -> {
            if (pluginDescriptor.getBundleDescriptor().getArtifactId().equals(this.plugin2Descriptor.getBundleDescriptor().getArtifactId())) {
                return Optional.of(() -> plugin2ClassLoader);
            }
            return Optional.empty();
        });
        ((DefaultArtifactClassLoaderResolver)Mockito.verify((Object)this.artifactClassLoaderResolver, (VerificationMode)Mockito.times((int)1))).createMulePluginClassLoader((MuleDeployableArtifactClassLoader)Mockito.any(), (ArtifactPluginDescriptor)Mockito.eq((Object)this.plugin2Descriptor), (PluginDescriptorResolver)Mockito.any());
        RegionClassLoader regionClassLoader = (RegionClassLoader)applicationClassLoader.getParent();
        MatcherAssert.assertThat(regionClassLoader.getArtifactPluginClassLoaders().stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{this.plugin1Descriptor, this.plugin2Descriptor}));
    }

    @Test
    public void createDependantPluginClassLoader() {
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Collections.emptyList());
        String plugin2ExportedPackage = "plugin2-package";
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR).setBundleUri(new File("test").toURI()).build();
        this.plugin1Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(pluginDependency)).build());
        this.plugin2Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(Collections.singleton(plugin2ExportedPackage)).build());
        MuleArtifactClassLoader pluginClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(applicationClassLoader, this.plugin1Descriptor, d -> Optional.of(this.plugin2Descriptor));
        MatcherAssert.assertThat((Object)pluginClassLoader.getParent(), (Matcher)Is.is((Object)applicationClassLoader.getParent()));
        MatcherAssert.assertThat((Object)pluginClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy(plugin2ExportedPackage), (Matcher)Is.is((Object)ParentFirstLookupStrategy.PARENT_FIRST));
    }

    @Test
    public void createPluginClassLoaderWithPrivilegedContainerAccess() {
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Collections.emptyList());
        MuleModule privilegedModule = (MuleModule)Mockito.mock(MuleModule.class);
        Mockito.when((Object)privilegedModule.getPrivilegedArtifacts()).thenReturn(Collections.singleton(PLUGIN_ARTIFACT_ID1));
        Mockito.when((Object)privilegedModule.getPrivilegedExportedPackages()).thenReturn(Collections.singleton(PRIVILEGED_PACKAGE));
        Mockito.when((Object)this.moduleRepository.getModules()).thenReturn(Collections.singletonList(privilegedModule));
        MuleArtifactClassLoader pluginClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(applicationClassLoader, this.plugin1Descriptor, d -> Optional.empty());
        MatcherAssert.assertThat((Object)pluginClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy(PRIVILEGED_PACKAGE), (Matcher)CoreMatchers.instanceOf(ContainerOnlyLookupStrategy.class));
    }

    @Test
    public void createsPluginClassLoaderWithPrivilegedPluginAccess() {
        ClassLoaderModel plugin2ClassLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder().exportingPrivilegedPackages(Collections.singleton(PRIVILEGED_PACKAGE), Collections.singleton(PLUGIN_ARTIFACT_ID1)).build();
        this.plugin2Descriptor.setClassLoaderModel(plugin2ClassLoaderModel);
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR).setBundleUri(new File("test").toURI()).build();
        this.plugin1Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(pluginDependency)).build());
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Collections.singletonList(this.plugin2Descriptor));
        MuleArtifactClassLoader pluginClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(applicationClassLoader, this.plugin1Descriptor, d -> Optional.of(this.plugin2Descriptor));
        MatcherAssert.assertThat((Object)pluginClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy(PRIVILEGED_PACKAGE), (Matcher)CoreMatchers.instanceOf(DelegateOnlyLookupStrategy.class));
    }

    @Test(expected=ArtifactActivationException.class)
    public void pluginClassLoadersOfDependenciesMustAlreadyExist() {
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Collections.emptyList());
        ClassLoaderModel plugin2ClassLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder().exportingPrivilegedPackages(Collections.singleton(PRIVILEGED_PACKAGE), Collections.singleton(PLUGIN_ARTIFACT_ID1)).build();
        this.plugin2Descriptor.setClassLoaderModel(plugin2ClassLoaderModel);
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR).setBundleUri(new File("test").toURI()).build();
        this.plugin1Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(pluginDependency)).build());
        this.artifactClassLoaderResolver.createMulePluginClassLoader(applicationClassLoader, this.plugin1Descriptor, d -> Optional.of(this.plugin2Descriptor));
    }

    @Test
    public void createPluginClassLoaderWithExportedLocalPackage() {
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Collections.emptyList());
        String pluginPackage = "plugin-package";
        ClassLoaderModel plugin2ClassLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(Collections.singleton(pluginPackage)).build();
        this.plugin2Descriptor.setClassLoaderModel(plugin2ClassLoaderModel);
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR).setBundleUri(new File("test").toURI()).build();
        this.plugin1Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().withLocalPackages(Collections.singleton(pluginPackage)).dependingOn(Collections.singleton(pluginDependency)).build());
        MuleArtifactClassLoader pluginClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(applicationClassLoader, this.plugin1Descriptor, d -> Optional.of(this.plugin2Descriptor));
        MatcherAssert.assertThat((Object)pluginClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy(pluginPackage), (Matcher)CoreMatchers.instanceOf(ChildOnlyLookupStrategy.class));
    }

    @Test
    public void createPluginClassLoaderWithIgnoredLocalPackages() {
        MuleModule muleModule = (MuleModule)Mockito.mock(MuleModule.class);
        String package1Name = "module&plugin-package";
        String package2Name = "org.mule.sdk.api.package";
        Mockito.when((Object)muleModule.getExportedPackages()).thenReturn(Stream.of("module&plugin-package", "org.mule.sdk.api.package").collect(Collectors.toSet()));
        Mockito.when((Object)this.moduleRepository.getModules()).thenReturn(Collections.singletonList(muleModule));
        MuleDeployableArtifactClassLoader applicationClassLoader = this.getTestApplicationClassLoader(Collections.emptyList());
        this.plugin1Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().withLocalPackages(Stream.of("module&plugin-package", "org.mule.sdk.api.package").collect(Collectors.toSet())).build());
        MuleArtifactClassLoader pluginClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(applicationClassLoader, this.plugin1Descriptor, d -> Optional.empty());
        MatcherAssert.assertThat((Object)pluginClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy("module&plugin-package"), (Matcher)CoreMatchers.instanceOf(ContainerOnlyLookupStrategy.class));
        MatcherAssert.assertThat((Object)pluginClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy("org.mule.sdk.api.package"), (Matcher)CoreMatchers.instanceOf(ParentFirstLookupStrategy.class));
    }

    @Test
    public void createPluginClassLoaderWithCachedPlugin() {
        ClassLoaderModel plugin2ClassLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder().exportingPrivilegedPackages(Collections.singleton(PRIVILEGED_PACKAGE), Collections.singleton(PLUGIN_ARTIFACT_ID1)).build();
        this.plugin2Descriptor.setClassLoaderModel(plugin2ClassLoaderModel);
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR).setBundleUri(new File("test").toURI()).build();
        this.plugin1Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(pluginDependency)).build());
        MuleDeployableArtifactClassLoader domainClassLoader = this.getTestDomainClassLoader(Collections.emptyList());
        MuleArtifactClassLoader plugin2ClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(domainClassLoader, this.plugin2Descriptor, d -> Optional.empty());
        MuleArtifactClassLoader pluginClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader(domainClassLoader, this.plugin1Descriptor, d -> Optional.of(this.plugin2Descriptor), (ownerClassLoader, pluginDescriptor) -> {
            if (pluginDescriptor.getBundleDescriptor().getArtifactId().equals(this.plugin2Descriptor.getBundleDescriptor().getArtifactId())) {
                return Optional.of(() -> plugin2ClassLoader);
            }
            return Optional.empty();
        });
        MatcherAssert.assertThat((Object)pluginClassLoader.getClassLoaderLookupPolicy().getPackageLookupStrategy(PRIVILEGED_PACKAGE), (Matcher)CoreMatchers.instanceOf(DelegateOnlyLookupStrategy.class));
    }

    private MuleDeployableArtifactClassLoader getTestDomainClassLoader(List<ArtifactPluginDescriptor> plugins) {
        return this.getTestDomainClassLoader(plugins, Collections.emptySet());
    }

    private MuleDeployableArtifactClassLoader getTestDomainClassLoader(List<ArtifactPluginDescriptor> plugins, Set<String> exportedPackages) {
        String domainName = "custom-domain";
        DomainDescriptor descriptor = this.getTestDomainDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir(MULE_DOMAIN_FOLDER, "custom-domain"));
        descriptor.setPlugins(new HashSet<ArtifactPluginDescriptor>(plugins));
        descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(exportedPackages).build());
        return this.artifactClassLoaderResolver.createDomainClassLoader(descriptor);
    }

    private MuleDeployableArtifactClassLoader getTestApplicationClassLoader(List<ArtifactPluginDescriptor> plugins) {
        return this.getTestApplicationClassLoader(plugins, Collections.emptySet());
    }

    private MuleDeployableArtifactClassLoader getTestApplicationClassLoader(List<ArtifactPluginDescriptor> plugins, Set<String> exportedPackages) {
        String applicationName = "app";
        MuleDeployableArtifactClassLoader domainClassLoader = this.getTestDomainClassLoader(Collections.emptyList());
        ApplicationDescriptor descriptor = new ApplicationDescriptor("app");
        descriptor.setArtifactLocation(new File(this.muleHomeFolder, "app"));
        descriptor.setPlugins(new HashSet<ArtifactPluginDescriptor>(plugins));
        descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(exportedPackages).build());
        return this.artifactClassLoaderResolver.createApplicationClassLoader(descriptor, () -> domainClassLoader);
    }

    private DomainDescriptor getTestDomainDescriptor(String name) {
        DomainDescriptor descriptor = new DomainDescriptor(name);
        descriptor.setRedeploymentEnabled(false);
        descriptor.setArtifactLocation(this.artifactLocation.getRoot());
        return descriptor;
    }

    protected File createDomainDir(String domainFolder, String domain) {
        File file = new File(this.muleHomeFolder, domainFolder + File.separator + domain);
        MatcherAssert.assertThat((Object)file.mkdirs(), (Matcher)Is.is((Object)true));
        return file;
    }
}

