/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.extension.discovery;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.DefaultExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.DefaultExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.ExtensionModelGenerator;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.RepositoryLookupExtensionModelGenerator;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.plugin.LoaderDescriber;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Extension Model Discovery")
public class DefaultExtensionModelDiscovererTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="MULE-19858")
    @Description(value="Check that not only 'mule' extension is loaded for xml sdk extension model generation, but all runtime ext models are (for instance: ee)")
    public void allRuntimeExtModelsDiscoveredForExtensionLoading() {
        String pluginName = "myPlugin";
        ArtifactPluginDescriptor descriptor = new ArtifactPluginDescriptor(pluginName);
        LoaderDescriber loaderDescriber = new LoaderDescriber("test");
        descriptor.setExtensionModelDescriptorProperty(loaderDescriber);
        descriptor.setBundleDescriptor(new BundleDescriptor.Builder().setGroupId("myGroup").setArtifactId(pluginName).setVersion("1.0").setClassifier("mule-plugin").build());
        final AtomicBoolean extensionDeclared = new AtomicBoolean();
        ExtensionModelLoader extModelLoader = new ExtensionModelLoader(){

            public String getId() {
                return "test";
            }

            protected void declareExtension(ExtensionLoadingContext context) {
                extensionDeclared.set(true);
                Assert.assertThat((Object)context.getDslResolvingContext().getExtension("mule").isPresent(), (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)context.getDslResolvingContext().getExtension("testRuntime").isPresent(), (Matcher)Is.is((Object)true));
                context.getExtensionDeclarer().named("test").onVersion("0.1").withCategory(Category.COMMUNITY).fromVendor("Mulesoft");
            }
        };
        ExtensionModelLoaderRepository loaderRepository = (ExtensionModelLoaderRepository)Mockito.mock(ExtensionModelLoaderRepository.class);
        Mockito.when((Object)loaderRepository.getExtensionModelLoader(loaderDescriber)).thenReturn(Optional.of(extModelLoader));
        ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        Mockito.when((Object)artifactClassLoader.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Set extensionModels = new DefaultExtensionModelDiscoverer((ExtensionModelGenerator)new RepositoryLookupExtensionModelGenerator(artifactPluginDescriptor -> artifactClassLoader, loaderRepository)).discoverPluginsExtensionModels((ExtensionDiscoveryRequest)new DefaultExtensionDiscoveryRequest(Collections.singletonList(descriptor), Collections.emptySet(), false, false));
        Assert.assertThat((Object)extensionDeclared.get(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)extensionModels.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(((ExtensionModel)extensionModels.stream().collect(Collectors.toList()).get(0)).getArtifactCoordinates().get(), (Matcher)Is.is((Object)descriptor.getBundleDescriptor()));
    }
}

