/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.extension.discovery;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.BufferedWriter;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoaderProvider;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.DefaultExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.plugin.LoaderDescriber;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@Feature(value="Extension Model Discovery")
@Story(value="Extension model loader repository")
@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultExtensionModelLoaderRepositoryTestCase
extends AbstractMuleTestCase {
    private static final String ID = "ID";
    private final LoaderDescriber loaderDescriber = new LoaderDescriber("ID");
    @Mock
    private ArtifactClassLoader containerClassLoader;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @After
    public void after() {
        ((ArtifactClassLoader)Mockito.verify((Object)this.containerClassLoader)).getClassLoader();
    }

    @Test
    public void noExtensionModelLoaderRegistered() throws MuleException {
        URLClassLoader emptyClassLoader = new URLClassLoader(new URL[0], this.getLauncherClassLoader(((Object)((Object)this)).getClass().getClassLoader()));
        Mockito.when((Object)this.containerClassLoader.getClassLoader()).thenReturn((Object)emptyClassLoader);
        DefaultExtensionModelLoaderRepository loaderRepository = new DefaultExtensionModelLoaderRepository(this.containerClassLoader.getClassLoader());
        loaderRepository.start();
        Optional loader = loaderRepository.getExtensionModelLoader(this.loaderDescriber);
        Assert.assertThat((Object)loader.isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void getExtensionModelLoaderRegistered() throws Exception {
        File serviceFolder = new File(this.temporaryFolder.newFolder("META-INF"), "services");
        Assert.assertThat((Object)serviceFolder.mkdirs(), (Matcher)Is.is((Object)true));
        File serviceFile = new File(serviceFolder, ExtensionModelLoaderProvider.class.getCanonicalName());
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(serviceFile.toURI()), new OpenOption[0]);){
            writer.write(TestExtensionModelLoaderProvider.class.getName());
            writer.newLine();
        }
        Mockito.when((Object)this.containerClassLoader.getClassLoader()).thenReturn((Object)new URLClassLoader(new URL[]{this.temporaryFolder.getRoot().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader()));
        DefaultExtensionModelLoaderRepository loaderRepository = new DefaultExtensionModelLoaderRepository(this.containerClassLoader.getClassLoader());
        loaderRepository.start();
        Optional loader = loaderRepository.getExtensionModelLoader(this.loaderDescriber);
        Assert.assertThat((Object)loader.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(loader.get(), (Matcher)IsInstanceOf.instanceOf(TestExtensionModelLoader.class));
    }

    private ClassLoader getLauncherClassLoader(ClassLoader classLoader) {
        ClassLoader launcherClassLoader = classLoader;
        while (classLoader != null) {
            launcherClassLoader = classLoader;
            classLoader = classLoader.getParent();
        }
        return launcherClassLoader;
    }

    public static class TestExtensionModelLoaderProvider
    implements ExtensionModelLoaderProvider {
        public Set<ExtensionModelLoader> getExtensionModelLoaders() {
            return Collections.singleton(new TestExtensionModelLoader());
        }
    }

    public static class TestExtensionModelLoader
    extends ExtensionModelLoader {
        public String getId() {
            return DefaultExtensionModelLoaderRepositoryTestCase.ID;
        }

        protected void declareExtension(ExtensionLoadingContext extensionLoadingContext) {
        }
    }
}

