/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginModelResolver;
import org.mule.runtime.module.artifact.activation.internal.deployable.DeployableClassLoaderConfigurationAssembler;
import org.mule.runtime.module.artifact.activation.internal.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.artifact.activation.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeployableArtifactDescriptorFactory<M extends MuleDeployableModel, T extends DeployableArtifactDescriptor>
extends AbstractArtifactDescriptorFactory<M, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeployableArtifactDescriptorFactory.class);
    private final DeployableProjectModel deployableProjectModel;
    private final Optional<Properties> deploymentProperties;
    private final PluginModelResolver pluginModelResolver;
    private final PluginDescriptorResolver pluginDescriptorResolver;
    private final BundlePluginDependenciesResolver pluginDependenciesResolver;

    public AbstractDeployableArtifactDescriptorFactory(DeployableProjectModel deployableProjectModel, Map<String, String> deploymentProperties, PluginModelResolver pluginModelResolver, PluginDescriptorResolver pluginDescriptorResolver, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(deployableProjectModel.getProjectFolder(), artifactDescriptorValidatorBuilder);
        this.deployableProjectModel = deployableProjectModel;
        this.deploymentProperties = this.asProperties(deploymentProperties);
        this.pluginModelResolver = pluginModelResolver;
        this.pluginDescriptorResolver = pluginDescriptorResolver;
        this.pluginDependenciesResolver = new BundlePluginDependenciesResolver();
    }

    private Optional<Properties> asProperties(Map<String, String> deploymentProperties) {
        Properties properties = new Properties();
        properties.putAll(deploymentProperties);
        return Optional.of(properties);
    }

    protected Optional<Properties> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    @Override
    protected ClassLoaderModel getClassLoaderModel(MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
        return new DeployableClassLoaderConfigurationAssembler(this.deployableProjectModel, muleArtifactLoaderDescriptor).createClassLoaderModel();
    }

    @Override
    protected BundleDescriptor getBundleDescriptor() {
        return this.deployableProjectModel.getDescriptor();
    }

    protected M getDeployableModel() {
        return (M)this.deployableProjectModel.getDeployableModel();
    }

    protected BundlePluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    @Override
    protected void doDescriptorConfig(T descriptor) {
        descriptor.setArtifactLocation(this.getArtifactLocation());
        descriptor.setRedeploymentEnabled(((MuleDeployableModel)this.getArtifactModel()).isRedeploymentEnabled());
        Set configs = ((MuleDeployableModel)this.getArtifactModel()).getConfigs();
        if (configs != null && !configs.isEmpty()) {
            descriptor.setConfigResources(new HashSet(configs));
        } else {
            descriptor.setConfigResources((Set)ImmutableSet.builder().add((Object)this.getDefaultConfigurationResource()).build());
        }
        descriptor.setPlugins(this.createArtifactPluginDescriptors((DeployableArtifactDescriptor)descriptor));
    }

    private Set<ArtifactPluginDescriptor> createArtifactPluginDescriptors(DeployableArtifactDescriptor descriptor) {
        HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
        for (BundleDependency bundlePluginDependency : descriptor.getClassLoaderModel().getDependencies()) {
            BundleDescriptor bundleDescriptor = bundlePluginDependency.getDescriptor();
            if (!bundleDescriptor.isPlugin()) continue;
            if (bundlePluginDependency.getBundleUri() == null) {
                LOGGER.warn(String.format("Plugin '%s' is declared as 'provided' which means that it will not be added to the artifact's classpath", bundleDescriptor));
                continue;
            }
            BundleDescriptor pluginDescriptor = this.deployableProjectModel.getDependencies().stream().map(BundleDependency::getDescriptor).filter(dependencyDescriptor -> "mule-plugin".equals(dependencyDescriptor.getClassifier().orElse(null))).filter(pluginDependencyDescriptor -> StringUtils.equals((CharSequence)bundleDescriptor.getArtifactId(), (CharSequence)pluginDependencyDescriptor.getArtifactId()) && StringUtils.equals((CharSequence)bundleDescriptor.getGroupId(), (CharSequence)pluginDependencyDescriptor.getGroupId()) && StringUtils.equals((CharSequence)bundleDescriptor.getVersion(), (CharSequence)pluginDependencyDescriptor.getVersion())).findFirst().orElseThrow(() -> new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)String.format("Dependency for plugin '%s' not found", bundleDescriptor))));
            List bundleDependencies = bundlePluginDependency.getTransitiveDependenciesList();
            pluginDescriptors.add(this.pluginDescriptorResolver.resolve(Collections.emptySet(), bundleDescriptor).orElse(this.createPluginDescriptor(bundlePluginDependency, this.pluginModelResolver.resolve(bundlePluginDependency), descriptor, bundleDependencies, new ArtifactCoordinates(pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), pluginDescriptor.getVersion()), this.deployableProjectModel.getDependencies(), this.deployableProjectModel.getSharedLibraries())));
        }
        return pluginDescriptors;
    }

    protected abstract String getDefaultConfigurationResource();

    private ArtifactPluginDescriptor createPluginDescriptor(BundleDependency bundleDependency, MulePluginModel pluginModel, DeployableArtifactDescriptor ownerDescriptor, List<BundleDependency> bundleDependencies, ArtifactCoordinates pluginArtifactCoordinates, List<BundleDependency> pluginDependencies, Set<BundleDescriptor> sharedPluginDependencies) {
        return (ArtifactPluginDescriptor)new ArtifactPluginDescriptorFactory(bundleDependency, pluginModel, ownerDescriptor, bundleDependencies, pluginArtifactCoordinates, pluginDependencies, sharedPluginDependencies, ArtifactDescriptorValidatorBuilder.builder()).create();
    }
}

