/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.activation.internal.classloader.Classifier;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.ArtifactUtils;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class AdditionalPluginDependenciesResolver {
    protected static final String MULE_EXTENSIONS_PLUGIN_GROUP_ID = "org.mule.runtime.plugins";
    protected static final String MULE_EXTENSIONS_PLUGIN_ARTIFACT_ID = "mule-extensions-maven-plugin";
    protected static final String MULE_MAVEN_PLUGIN_GROUP_ID = "org.mule.tools.maven";
    protected static final String MULE_MAVEN_PLUGIN_ARTIFACT_ID = "mule-maven-plugin";
    protected static final String ADDITIONAL_PLUGIN_DEPENDENCIES_ELEMENT = "additionalPluginDependencies";
    protected static final String ADDITIONAL_DEPENDENCIES_ELEMENT = "additionalDependencies";
    protected static final String GROUP_ID_ELEMENT = "groupId";
    protected static final String ARTIFACT_ID_ELEMENT = "artifactId";
    protected static final String VERSION_ELEMENT = "version";
    protected static final String PLUGIN_ELEMENT = "plugin";
    protected static final String DEPENDENCY_ELEMENT = "dependency";
    private final AetherMavenClient aetherMavenClient;
    private final List<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin> pluginsWithAdditionalDependencies;
    private final File temporaryFolder;

    public AdditionalPluginDependenciesResolver(AetherMavenClient muleMavenPluginClient, List<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin> additionalPluginDependencies, File temporaryFolder) {
        this.aetherMavenClient = muleMavenPluginClient;
        this.pluginsWithAdditionalDependencies = new ArrayList<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin>(additionalPluginDependencies);
        this.temporaryFolder = temporaryFolder;
    }

    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> applicationDependencies, Map<ArtifactCoordinates, List<Artifact>> pluginsDependencies) {
        this.addPluginDependenciesAdditionalLibraries(applicationDependencies);
        LinkedHashMap<BundleDependency, List<BundleDependency>> pluginsWithAdditionalDeps = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (org.mule.runtime.module.artifact.activation.internal.plugin.Plugin pluginWithAdditionalDependencies : this.pluginsWithAdditionalDependencies) {
            BundleDependency pluginBundleDependency = this.getPluginBundleDependency(pluginWithAdditionalDependencies, applicationDependencies);
            List<Artifact> pluginDependencies = this.getPluginDependencies(pluginWithAdditionalDependencies, pluginsDependencies);
            List<BundleDependency> additionalDependencies = this.resolveDependencies(pluginWithAdditionalDependencies.getAdditionalDependencies().stream().filter(additionalDep -> pluginDependencies.stream().noneMatch(artifactDependency -> this.areSameArtifact((Dependency)additionalDep, (Artifact)artifactDependency))).collect(Collectors.toList()));
            if (additionalDependencies.isEmpty()) continue;
            pluginsWithAdditionalDeps.put(pluginBundleDependency, additionalDependencies);
        }
        return pluginsWithAdditionalDeps;
    }

    private List<BundleDependency> resolveDependencies(List<Dependency> additionalDependencies) {
        return this.aetherMavenClient.resolveArtifactDependencies(additionalDependencies.stream().map(ArtifactUtils::toBundleDescriptor).collect(Collectors.toList()), Optional.of(this.aetherMavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation()), Optional.empty());
    }

    private BundleDependency getPluginBundleDependency(org.mule.runtime.module.artifact.activation.internal.plugin.Plugin plugin, List<BundleDependency> mulePlugins) {
        return mulePlugins.stream().filter(mulePlugin -> StringUtils.equals((CharSequence)mulePlugin.getDescriptor().getArtifactId(), (CharSequence)plugin.getArtifactId()) && StringUtils.equals((CharSequence)mulePlugin.getDescriptor().getGroupId(), (CharSequence)plugin.getGroupId())).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Declared additional dependencies for a plugin not present: " + plugin))));
    }

    private List<Artifact> getPluginDependencies(org.mule.runtime.module.artifact.activation.internal.plugin.Plugin plugin, Map<ArtifactCoordinates, List<Artifact>> pluginsDependencies) {
        return pluginsDependencies.entrySet().stream().filter(pluginDependenciesEntry -> StringUtils.equals((CharSequence)((ArtifactCoordinates)pluginDependenciesEntry.getKey()).getGroupId(), (CharSequence)plugin.getGroupId()) && StringUtils.equals((CharSequence)((ArtifactCoordinates)pluginDependenciesEntry.getKey()).getArtifactId(), (CharSequence)plugin.getArtifactId())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not find ClassLoaderModel resolved for plugin: " + plugin))));
    }

    private boolean areSameArtifact(Dependency dependency, Artifact artifact) {
        return StringUtils.equals((CharSequence)dependency.getArtifactId(), (CharSequence)artifact.getArtifactCoordinates().getArtifactId()) && StringUtils.equals((CharSequence)dependency.getGroupId(), (CharSequence)artifact.getArtifactCoordinates().getGroupId()) && StringUtils.equals((CharSequence)dependency.getVersion(), (CharSequence)artifact.getArtifactCoordinates().getVersion());
    }

    private String getChildParameterValue(Xpp3Dom element, String childName, boolean validate) {
        String childValue;
        Xpp3Dom child = element.getChild(childName);
        String string = childValue = child != null ? child.getValue() : null;
        if (StringUtils.isEmpty((CharSequence)childValue) && validate) {
            throw new IllegalArgumentException("Expecting child element with not null value " + childName);
        }
        return childValue;
    }

    private void addPluginDependenciesAdditionalLibraries(List<BundleDependency> applicationDependencies) {
        List<BundleDependency> mulePlugins = applicationDependencies.stream().filter(bundleDependency -> Classifier.MULE_PLUGIN.equals((String)bundleDependency.getDescriptor().getClassifier().orElse(null))).collect(Collectors.toList());
        Collection<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin> additionalDependenciesFromMulePlugins = this.resolveAdditionalDependenciesFromMulePlugins(mulePlugins);
        this.pluginsWithAdditionalDependencies.addAll(additionalDependenciesFromMulePlugins.stream().filter(this.isNotRedefinedAtApplicationLevel()).collect(Collectors.toList()));
    }

    protected Collection<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin> resolveAdditionalDependenciesFromMulePlugins(List<BundleDependency> mulePlugins) {
        HashMap additionalDependenciesFromMulePlugins = new HashMap();
        mulePlugins.forEach(mulePlugin -> {
            try {
                Model pomModel = this.aetherMavenClient.getEffectiveModel(FileUtils.toFile((URL)mulePlugin.getBundleUri().toURL()), Optional.of(this.temporaryFolder));
                Build build = pomModel.getBuild();
                if (build != null) {
                    Xpp3Dom[] additionalPluginDependencies;
                    Xpp3Dom additionalPluginDependenciesDom;
                    Object configurationObject;
                    Plugin packagerPlugin = (Plugin)build.getPluginsAsMap().get("org.mule.runtime.plugins:mule-extensions-maven-plugin");
                    if (packagerPlugin == null) {
                        packagerPlugin = (Plugin)build.getPluginsAsMap().get("org.mule.tools.maven:mule-maven-plugin");
                    }
                    if (packagerPlugin != null && (configurationObject = packagerPlugin.getConfiguration()) != null && (additionalPluginDependenciesDom = ((Xpp3Dom)configurationObject).getChild(ADDITIONAL_PLUGIN_DEPENDENCIES_ELEMENT)) != null && (additionalPluginDependencies = additionalPluginDependenciesDom.getChildren(PLUGIN_ELEMENT)) != null) {
                        Arrays.stream(additionalPluginDependencies).forEach(additonalPluginDependencyDom -> {
                            String pluginGroupId = this.getChildParameterValue((Xpp3Dom)additonalPluginDependencyDom, GROUP_ID_ELEMENT, true);
                            String pluginArtifactId = this.getChildParameterValue((Xpp3Dom)additonalPluginDependencyDom, ARTIFACT_ID_ELEMENT, true);
                            org.mule.runtime.module.artifact.activation.internal.plugin.Plugin alreadyDefinedPluginAdditionalDependencies = (org.mule.runtime.module.artifact.activation.internal.plugin.Plugin)additionalDependenciesFromMulePlugins.get(pluginGroupId + ":" + pluginArtifactId);
                            List<Dependency> additionalDependencyDependencies = Arrays.stream(additonalPluginDependencyDom.getChild(ADDITIONAL_DEPENDENCIES_ELEMENT).getChildren(DEPENDENCY_ELEMENT)).map(dependencyDom -> {
                                Dependency dependency = new Dependency();
                                dependency.setGroupId(this.getChildParameterValue((Xpp3Dom)dependencyDom, GROUP_ID_ELEMENT, true));
                                dependency.setArtifactId(this.getChildParameterValue((Xpp3Dom)dependencyDom, ARTIFACT_ID_ELEMENT, true));
                                dependency.setVersion(this.getChildParameterValue((Xpp3Dom)dependencyDom, VERSION_ELEMENT, true));
                                String type = this.getChildParameterValue((Xpp3Dom)dependencyDom, "type", false);
                                dependency.setType(type == null ? "jar" : type);
                                dependency.setClassifier(this.getChildParameterValue((Xpp3Dom)dependencyDom, "classifier", false));
                                dependency.setSystemPath(this.getChildParameterValue((Xpp3Dom)dependencyDom, "systemPath", false));
                                return dependency;
                            }).collect(Collectors.toList());
                            if (alreadyDefinedPluginAdditionalDependencies != null) {
                                LinkedList<Dependency> effectiveDependencies = new LinkedList<Dependency>(alreadyDefinedPluginAdditionalDependencies.getAdditionalDependencies());
                                additionalDependencyDependencies.forEach(additionalDependenciesDependency -> {
                                    boolean addDependency = true;
                                    for (int i = 0; i < effectiveDependencies.size(); ++i) {
                                        Dependency effectiveDependency = (Dependency)effectiveDependencies.get(i);
                                        if (!effectiveDependency.getGroupId().equals(additionalDependenciesDependency.getGroupId()) || !effectiveDependency.getArtifactId().equals(additionalDependenciesDependency.getArtifactId()) || !effectiveDependency.getType().equals(additionalDependenciesDependency.getType()) || ObjectUtils.compare((Comparable)((Object)effectiveDependency.getClassifier()), (Comparable)((Object)additionalDependenciesDependency.getClassifier())) != 0) continue;
                                        if (this.isNewerVersion(additionalDependenciesDependency.getVersion(), effectiveDependency.getVersion())) {
                                            effectiveDependencies.remove(i);
                                            break;
                                        }
                                        addDependency = false;
                                        break;
                                    }
                                    if (addDependency) {
                                        effectiveDependencies.add((Dependency)additionalDependenciesDependency);
                                    }
                                });
                                alreadyDefinedPluginAdditionalDependencies.setAdditionalDependencies(effectiveDependencies);
                            } else {
                                org.mule.runtime.module.artifact.activation.internal.plugin.Plugin plugin = new org.mule.runtime.module.artifact.activation.internal.plugin.Plugin();
                                plugin.setGroupId(pluginGroupId);
                                plugin.setArtifactId(pluginArtifactId);
                                plugin.setAdditionalDependencies(additionalDependencyDependencies);
                                additionalDependenciesFromMulePlugins.put(plugin.getGroupId() + ":" + plugin.getArtifactId(), plugin);
                            }
                        });
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
        return additionalDependenciesFromMulePlugins.values();
    }

    private boolean isNewerVersion(String dependencyA, String dependencyB) {
        try {
            return new Semver(dependencyA, Semver.SemverType.LOOSE).isGreaterThan(new Semver(dependencyB, Semver.SemverType.LOOSE));
        }
        catch (IllegalArgumentException e) {
            return dependencyA.compareTo(dependencyB) > 0;
        }
    }

    private Predicate<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin> isNotRedefinedAtApplicationLevel() {
        return dependencyPluginAdditionalDependencies -> !this.pluginsWithAdditionalDependencies.stream().filter(applicationPluginAdditionalDependency -> dependencyPluginAdditionalDependencies.getGroupId().equals(applicationPluginAdditionalDependency.getGroupId()) && dependencyPluginAdditionalDependencies.getArtifactId().equals(applicationPluginAdditionalDependency.getArtifactId())).findAny().isPresent();
    }
}

