/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.plugin;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.module.artifact.activation.internal.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.internal.plugin.PluginClassLoaderConfigurationAssembler;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.plugin.LoaderDescriber;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class ArtifactPluginDescriptorFactory
extends AbstractArtifactDescriptorFactory<MulePluginModel, ArtifactPluginDescriptor> {
    private final MulePluginModel pluginModel;
    private final BundleDescriptor bundleDescriptor;
    private final DeployableArtifactDescriptor ownerDescriptor;
    private final List<BundleDependency> bundleDependencies;
    private final ArtifactCoordinates pluginArtifactCoordinates;
    private final List<BundleDependency> projectDependencies;
    private final Set<BundleDescriptor> sharedProjectDependencies;

    public ArtifactPluginDescriptorFactory(BundleDependency bundleDependency, MulePluginModel pluginModel, DeployableArtifactDescriptor ownerDescriptor, List<BundleDependency> bundleDependencies, ArtifactCoordinates pluginArtifactCoordinates, List<BundleDependency> projectDependencies, Set<BundleDescriptor> sharedProjectDependencies, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(new File(bundleDependency.getBundleUri()), artifactDescriptorValidatorBuilder);
        this.pluginModel = pluginModel;
        this.bundleDescriptor = bundleDependency.getDescriptor();
        this.ownerDescriptor = ownerDescriptor;
        this.bundleDependencies = bundleDependencies;
        this.pluginArtifactCoordinates = pluginArtifactCoordinates;
        this.projectDependencies = projectDependencies;
        this.sharedProjectDependencies = sharedProjectDependencies;
    }

    @Override
    protected MulePluginModel createArtifactModel() {
        return this.pluginModel;
    }

    @Override
    protected void doDescriptorConfig(ArtifactPluginDescriptor descriptor) {
        ((MulePluginModel)this.getArtifactModel()).getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptor -> {
            LoaderDescriber loaderDescriber = new LoaderDescriber(extensionModelDescriptor.getId());
            loaderDescriber.addAttributes(extensionModelDescriptor.getAttributes());
            descriptor.setExtensionModelDescriptorProperty(loaderDescriber);
        });
        ((MulePluginModel)this.getArtifactModel()).getLicense().ifPresent(arg_0 -> ((ArtifactPluginDescriptor)descriptor).setLicenseModel(arg_0));
    }

    @Override
    protected ClassLoaderModel getClassLoaderModel(MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
        return new PluginClassLoaderConfigurationAssembler(this.pluginArtifactCoordinates, this.projectDependencies, this.sharedProjectDependencies, this.getArtifactLocation(), muleArtifactLoaderDescriptor, this.bundleDependencies, this.bundleDescriptor, this.ownerDescriptor).createClassLoaderModel();
    }

    @Override
    protected BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    @Override
    protected ArtifactPluginDescriptor doCreateArtifactDescriptor() {
        return new ArtifactPluginDescriptor(((MulePluginModel)this.getArtifactModel()).getName(), Optional.empty());
    }
}

