/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.extension.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.mule.api.annotation.NoImplement;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.DefaultExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

@NoImplement
public interface ExtensionDiscoveryRequest {
    public static ExtensionDiscoveryRequestBuilder builder() {
        return new ExtensionDiscoveryRequestBuilder();
    }

    public Collection<ArtifactPluginDescriptor> getArtifactPluginDescriptors();

    public Set<ExtensionModel> getParentArtifactExtensions();

    public boolean isParallelDiscovery();

    public boolean isEnrichDescriptions();

    @NoInstantiate
    public static final class ExtensionDiscoveryRequestBuilder {
        private Collection<ArtifactPluginDescriptor> artifactPlugins;
        private Set<ExtensionModel> parentArtifactExtensions = Collections.emptySet();
        private boolean parallelDiscovery = false;
        private boolean enrichDescriptions = true;

        public ExtensionDiscoveryRequestBuilder setArtifactPlugins(Collection<ArtifactPluginDescriptor> artifactPlugins) {
            this.artifactPlugins = artifactPlugins;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setParentArtifactExtensions(Set<ExtensionModel> parentArtifactExtensions) {
            this.parentArtifactExtensions = parentArtifactExtensions;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setEnrichDescriptions(boolean enrichDescriptions) {
            this.enrichDescriptions = enrichDescriptions;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setParallelDiscovery(boolean parallelDiscovery) {
            this.parallelDiscovery = parallelDiscovery;
            return this;
        }

        public ExtensionDiscoveryRequest build() {
            return new DefaultExtensionDiscoveryRequest(this.artifactPlugins, this.parentArtifactExtensions, this.parallelDiscovery, this.enrichDescriptions);
        }
    }
}

