/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactClassLoaderConfigurationAssembler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArtifactClassLoaderConfigurationAssembler.class);
    private static final String MULE_RUNTIME_GROUP_ID = "org.mule.runtime";
    private static final String MULE_RUNTIME_MODULES_GROUP_ID = "com.mulesoft.mule.runtime.modules";
    private final ClassLoaderModel packagerClassLoaderModel;
    private final MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor;

    public AbstractArtifactClassLoaderConfigurationAssembler(ClassLoaderModel packagerClassLoaderModel, MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
        this.packagerClassLoaderModel = packagerClassLoaderModel;
        this.muleArtifactLoaderDescriptor = muleArtifactLoaderDescriptor;
    }

    public org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel createClassLoaderModel() {
        ClassLoaderModel.ClassLoaderModelBuilder classLoaderConfigurationBuilder = this.getClassLoaderConfigurationBuilder();
        if (this.muleArtifactLoaderDescriptor != null) {
            classLoaderConfigurationBuilder.exportingPackages((Set)Sets.newHashSet(this.getAttribute(this.muleArtifactLoaderDescriptor.getAttributes(), "exportedPackages"))).exportingResources((Set)Sets.newHashSet(this.getAttribute(this.muleArtifactLoaderDescriptor.getAttributes(), "exportedResources"))).exportingPrivilegedPackages(new HashSet<String>(this.getAttribute(this.muleArtifactLoaderDescriptor.getAttributes(), "privilegedExportedPackages")), new HashSet<String>(this.getAttribute(this.muleArtifactLoaderDescriptor.getAttributes(), "privilegedArtifactIds")));
        }
        List<BundleDependency> bundleDependencies = this.getBundleDependencies();
        List<URL> dependenciesArtifactsUrls = this.loadUrls(this.getProjectFolder(), bundleDependencies, classLoaderConfigurationBuilder);
        dependenciesArtifactsUrls.forEach(arg_0 -> ((ClassLoaderModel.ClassLoaderModelBuilder)classLoaderConfigurationBuilder).containing(arg_0));
        if (this.shouldPopulateLocalPackages()) {
            this.populateLocalPackages(this.packagerClassLoaderModel, classLoaderConfigurationBuilder);
        }
        classLoaderConfigurationBuilder.dependingOn(new HashSet<BundleDependency>(bundleDependencies));
        return classLoaderConfigurationBuilder.build();
    }

    private List<String> getAttribute(Map<String, Object> attributes, String attribute) {
        if (attributes == null) {
            return Collections.emptyList();
        }
        ArrayList attributeObject = attributes.getOrDefault(attribute, new ArrayList());
        Preconditions.checkArgument((boolean)(attributeObject instanceof List), (String)String.format("The '%s' attribute must be of '%s', found '%s'", attribute, List.class.getName(), attributeObject.getClass().getName()));
        return attributeObject;
    }

    protected abstract ClassLoaderModel.ClassLoaderModelBuilder getClassLoaderConfigurationBuilder();

    protected boolean shouldPopulateLocalPackages() {
        return true;
    }

    private List<URL> loadUrls(File artifactFile, List<BundleDependency> dependencies, ClassLoaderModel.ClassLoaderModelBuilder classLoaderConfigurationBuilder) {
        ArrayList<URL> dependenciesArtifactsUrls = new ArrayList<URL>();
        dependenciesArtifactsUrls.add(this.getUrl(artifactFile));
        dependenciesArtifactsUrls.addAll(this.addArtifactSpecificClassLoaderConfiguration(classLoaderConfigurationBuilder));
        dependenciesArtifactsUrls.addAll(this.addDependenciesToClasspathUrls(dependencies));
        return dependenciesArtifactsUrls;
    }

    protected Collection<URL> addArtifactSpecificClassLoaderConfiguration(ClassLoaderModel.ClassLoaderModelBuilder classLoaderConfigurationBuilder) {
        return Collections.emptyList();
    }

    private List<URL> addDependenciesToClasspathUrls(List<BundleDependency> dependencies) {
        ArrayList<URL> dependenciesArtifactsUrls = new ArrayList<URL>();
        dependencies.stream().filter(dependency -> !"mule-plugin".equals(dependency.getDescriptor().getClassifier().orElse(null))).filter(dependency -> dependency.getBundleUri() != null).filter(dependency -> !this.validateMuleRuntimeSharedLibrary(dependency.getDescriptor().getGroupId(), dependency.getDescriptor().getArtifactId(), this.packagerClassLoaderModel.getArtifactCoordinates().getArtifactId())).forEach(dependency -> {
            URL dependencyArtifactUrl;
            try {
                dependencyArtifactUrl = dependency.getBundleUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            dependenciesArtifactsUrls.add(dependencyArtifactUrl);
        });
        return dependenciesArtifactsUrls;
    }

    private URL getUrl(File artifactFile) {
        try {
            return artifactFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)String.format("There was an exception obtaining the URL for the artifact [%s]", artifactFile.getAbsolutePath())), e);
        }
    }

    private boolean validateMuleRuntimeSharedLibrary(String groupId, String artifactId, String artifactFileName) {
        if (MULE_RUNTIME_GROUP_ID.equals(groupId) || MULE_RUNTIME_MODULES_GROUP_ID.equals(groupId)) {
            LOGGER.warn("Shared library '{}:{}' is a Mule Runtime dependency. It will not be used by '{}' in order to avoid classloading issues. Please consider removing it, or at least not putting it as a sharedLibrary.", new Object[]{groupId, artifactId, artifactFileName});
            return true;
        }
        return false;
    }

    protected void populateLocalPackages(ClassLoaderModel packagerClassLoaderModel, ClassLoaderModel.ClassLoaderModelBuilder classLoaderConfigurationBuilder) {
        ImmutableSet.Builder packagesSetBuilder = ImmutableSet.builder();
        if (packagerClassLoaderModel.getPackages() != null) {
            packagesSetBuilder.add((Object[])packagerClassLoaderModel.getPackages());
        }
        ImmutableSet.Builder resourcesSetBuilder = ImmutableSet.builder();
        if (packagerClassLoaderModel.getResources() != null) {
            resourcesSetBuilder.add((Object[])packagerClassLoaderModel.getResources());
        }
        packagerClassLoaderModel.getDependencies().forEach(artifact -> {
            if (!("mule-plugin".equals(artifact.getArtifactCoordinates().getClassifier()) || "mule-domain".equals(artifact.getArtifactCoordinates().getClassifier()) || this.validateMuleRuntimeSharedLibrary(artifact.getArtifactCoordinates().getGroupId(), artifact.getArtifactCoordinates().getArtifactId(), packagerClassLoaderModel.getArtifactCoordinates().getArtifactId()) || artifact.getUri() == null)) {
                if (artifact.getPackages() != null) {
                    packagesSetBuilder.add((Object[])artifact.getPackages());
                }
                if (artifact.getResources() != null) {
                    resourcesSetBuilder.add((Object[])artifact.getResources());
                }
            }
        });
        classLoaderConfigurationBuilder.withLocalPackages((Set)packagesSetBuilder.build());
        classLoaderConfigurationBuilder.withLocalResources((Set)resourcesSetBuilder.build());
    }

    protected ClassLoaderModel getPackagerClassLoaderModel() {
        return this.packagerClassLoaderModel;
    }

    protected abstract List<BundleDependency> getBundleDependencies();

    protected abstract File getProjectFolder();
}

