/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginPatchesResolver;
import org.mule.runtime.module.artifact.activation.internal.plugin.MuleArtifactPatchingModel;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginPatchesResolver
implements PluginPatchesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPluginPatchesResolver.class);
    private static final String MULE_ARTIFACT_PATCHES_LOCATION = "lib/patches/mule-artifact-patches";
    private static final String PATCH_FILES_EXTENSION = "jar";

    @Override
    public List<URL> resolve(ArtifactCoordinates pluginArtifactCoordinates) {
        Version pluginArtifactCoordinatesVersion;
        List<URL> patches = new ArrayList<URL>();
        String artifactId = pluginArtifactCoordinates.getGroupId() + ":" + pluginArtifactCoordinates.getArtifactId() + ":" + pluginArtifactCoordinates.getVersion();
        GenericVersionScheme genericVersionScheme = new GenericVersionScheme();
        try {
            pluginArtifactCoordinatesVersion = genericVersionScheme.parseVersion(pluginArtifactCoordinates.getVersion());
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing version '{}' for artifact '{}', patches against this artifact will not be applied", (Object)pluginArtifactCoordinates.getVersion(), (Object)artifactId);
            return Collections.emptyList();
        }
        File muleArtifactPatchesFolder = new File(MuleFoldersUtil.getMuleHomeFolder(), MULE_ARTIFACT_PATCHES_LOCATION);
        try {
            if (muleArtifactPatchesFolder.exists()) {
                patches = Files.walk(muleArtifactPatchesFolder.toPath(), new FileVisitOption[0]).filter(patchFilePath -> FilenameUtils.getExtension((String)patchFilePath.toString()).endsWith(PATCH_FILES_EXTENSION)).map(patchFilePath -> {
                    try {
                        MuleArtifactPatchingModel muleArtifactPatchingModel = MuleArtifactPatchingModel.loadModel(patchFilePath.toFile());
                        ArtifactCoordinates patchedArtifactCoordinates = muleArtifactPatchingModel.getArtifactCoordinates();
                        if (patchedArtifactCoordinates.getGroupId().equals(pluginArtifactCoordinates.getGroupId()) && patchedArtifactCoordinates.getArtifactId().equals(pluginArtifactCoordinates.getArtifactId()) && patchedArtifactCoordinates.getClassifier().equals("mule-plugin") && muleArtifactPatchingModel.getAffectedVersions().stream().anyMatch(affectedVersion -> {
                            try {
                                VersionConstraint versionConstraint = genericVersionScheme.parseVersionConstraint(affectedVersion);
                                return versionConstraint.containsVersion(pluginArtifactCoordinatesVersion);
                            }
                            catch (InvalidVersionSpecificationException e) {
                                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not parse plugin patch affect version '%s'", affectedVersion)), (Throwable)e);
                            }
                        })) {
                            LOGGER.info("Patching artifact '{}' with patch file '{}'", (Object)artifactId, patchFilePath);
                            return patchFilePath.toFile().toURI().toURL();
                        }
                    }
                    catch (IOException e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There was an error processing the patch in '%s' file", patchFilePath)), (Throwable)e);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There was an error processing the patches in '%s'", muleArtifactPatchesFolder)), (Throwable)e);
        }
        return patches;
    }
}

