/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.ArtifactUtils;
import org.mule.runtime.module.artifact.activation.internal.deployable.AbstractDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.deployable.DeployablePluginsDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.AdditionalPluginDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.DeployableDependencyResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public abstract class AbstractMavenDeployableProjectModelBuilder
extends AbstractDeployableProjectModelBuilder {
    protected static final String DEFAULT_PACKAGE_EXPORT = "";
    protected static final String JAVA_EXTENSION = "java";
    protected static final String PACKAGE_SEPARATOR = ".";
    protected static final String GROUP_ID = "groupId";
    protected static final String ARTIFACT_ID = "artifactId";
    protected static final String VERSION = "version";
    protected static final String CLASS_PATH_SEPARATOR = "/";
    protected static final String DEFAULT_SOURCES_DIRECTORY = "src/main";
    protected static final String DEFAULT_SOURCES_JAVA_DIRECTORY = "/java";
    protected static final String DEFAULT_RESOURCES_DIRECTORY = "/resources";
    protected static final String DEFAULT_MULE_DIRECTORY = "/mule";
    protected final MavenConfiguration mavenConfiguration;
    protected List<BundleDependency> deployableMavenBundleDependencies;
    protected List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> deployableBundleDependencies;
    protected Map<ArtifactCoordinates, List<Artifact>> pluginsArtifactDependencies;
    protected Set<BundleDescriptor> sharedDeployableBundleDescriptors;
    protected Map<BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> additionalPluginDependencies;
    protected Map<BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> pluginsBundleDependencies;
    protected File deployableArtifactRepositoryFolder;

    protected static MavenConfiguration getDefaultMavenConfiguration() {
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)MavenDeployableProjectModelBuilder.class.getClassLoader());
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation((File)localMavenRepository.get());
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    protected AbstractMavenDeployableProjectModelBuilder(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
    }

    protected ArtifactCoordinates getDeployableProjectArtifactCoordinates(Model pomModel) {
        ApplicationGAVModel deployableGAVModel = new ApplicationGAVModel(pomModel.getGroupId(), pomModel.getArtifactId(), pomModel.getVersion());
        return ArtifactUtils.getDeployableArtifactCoordinates(pomModel, deployableGAVModel);
    }

    protected BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType(artifactCoordinates.getType()).setClassifier(artifactCoordinates.getClassifier()).build();
    }

    protected void resolveDeployableDependencies(AetherMavenClient aetherMavenClient, File pom, Model pomModel, List<String> activeProfiles) {
        DeployableDependencyResolver deployableDependencyResolver = new DeployableDependencyResolver(aetherMavenClient);
        this.deployableMavenBundleDependencies = deployableDependencyResolver.resolveDeployableDependencies(pom, false, Optional.empty());
        List<Artifact> deployableArtifactDependencies = ArtifactUtils.updateArtifactsSharedState(this.deployableMavenBundleDependencies, ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts(this.deployableMavenBundleDependencies)), pomModel, activeProfiles);
        this.deployableBundleDependencies = deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        this.sharedDeployableBundleDescriptors = this.deployableBundleDependencies.stream().filter(bd -> deployableArtifactDependencies.stream().anyMatch(artifact -> artifact.isShared() && bd.getDescriptor().getGroupId().equals(artifact.getArtifactCoordinates().getGroupId()) && bd.getDescriptor().getArtifactId().equals(artifact.getArtifactCoordinates().getArtifactId()))).map(org.mule.runtime.module.artifact.api.descriptor.BundleDependency::getDescriptor).collect(Collectors.toSet());
    }

    protected void resolveAdditionalPluginDependencies(AetherMavenClient aetherMavenClient, Model pomModel, List<String> activeProfiles, Map<ArtifactCoordinates, List<Artifact>> pluginsDependencies) {
        List<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin> initialAdditionalPluginDependencies = this.findArtifactPackagerPlugin(pomModel, activeProfiles).map(this::getAdditionalPluginDependencies).orElse(Collections.emptyList());
        AdditionalPluginDependenciesResolver additionalPluginDependenciesResolver = new AdditionalPluginDependenciesResolver(aetherMavenClient, initialAdditionalPluginDependencies, new File("temp"));
        this.additionalPluginDependencies = this.toPluginDependencies(additionalPluginDependenciesResolver.resolveDependencies(this.deployableMavenBundleDependencies, pluginsDependencies));
    }

    protected void resolveDeployablePluginsData(List<BundleDependency> deployableMavenBundleDependencies) {
        this.pluginsArtifactDependencies = new DeployablePluginsDependenciesResolver().resolve(deployableMavenBundleDependencies);
        HashMap pluginsBundleDescriptors = new HashMap();
        this.pluginsArtifactDependencies.keySet().forEach(pluginArtifactCoordinates -> pluginsBundleDescriptors.put(pluginArtifactCoordinates, this.buildBundleDescriptor((ArtifactCoordinates)pluginArtifactCoordinates)));
        this.pluginsBundleDependencies = new HashMap<BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>>();
        this.pluginsArtifactDependencies.forEach((pluginArtifactCoordinates, pluginDependencies) -> this.pluginsBundleDependencies.put((BundleDescriptor)pluginsBundleDescriptors.get(pluginArtifactCoordinates), pluginDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList())));
        this.deployableBundleDependencies = this.deployableBundleDependencies.stream().map(dbd -> new BundleDependency.Builder(dbd).setTransitiveDependencies(this.pluginsBundleDependencies.get(dbd.getDescriptor())).build()).collect(Collectors.toList());
    }

    private Map<BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> toPluginDependencies(Map<BundleDependency, List<BundleDependency>> pluginsAndDependencies) {
        return pluginsAndDependencies.entrySet().stream().collect(Collectors.toMap(entry -> this.deployableBundleDependencies.stream().filter(bd -> bd.getDescriptor().getGroupId().equals(((BundleDependency)entry.getKey()).getDescriptor().getGroupId()) && bd.getDescriptor().getArtifactId().equals(((BundleDependency)entry.getKey()).getDescriptor().getArtifactId())).map(org.mule.runtime.module.artifact.api.descriptor.BundleDependency::getDescriptor).findAny().get(), entry -> {
            List<Artifact> deployableArtifactDependencies = ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts((List)entry.getValue()));
            return deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        }));
    }

    private Function<Artifact, org.mule.runtime.module.artifact.api.descriptor.BundleDependency> createBundleDependencyFromPackagerDependency(Function<URI, URI> uriResolver) {
        return d -> {
            URI bundle = d.getUri();
            if (!d.getUri().isAbsolute()) {
                bundle = (URI)uriResolver.apply(d.getUri());
            }
            return new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(d.getArtifactCoordinates().getArtifactId()).setGroupId(d.getArtifactCoordinates().getGroupId()).setClassifier(d.getArtifactCoordinates().getClassifier()).setType(d.getArtifactCoordinates().getType()).setVersion(d.getArtifactCoordinates().getVersion()).setBaseVersion(d.getArtifactCoordinates().getVersion()).build()).setBundleUri(bundle).setPackages(d.getPackages() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getPackages())).setResources(d.getResources() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getResources())).build();
        };
    }

    private Function<URI, URI> getDeployableArtifactRepositoryUriResolver() {
        return uri -> new File(this.deployableArtifactRepositoryFolder, uri.toString()).toURI();
    }

    private Optional<Plugin> findArtifactPackagerPlugin(Model model, List<String> activeProfiles) {
        Stream basePlugin = Stream.empty();
        Build build = model.getBuild();
        if (build != null) {
            basePlugin = this.findArtifactPackagerPlugin(build.getPlugins()).map(Stream::of).orElse(Stream.empty());
        }
        List sortedActiveProfiles = activeProfiles.stream().sorted(String::compareTo).collect(Collectors.toList());
        Stream<Plugin> packagerConfigsForActivePluginsStream = model.getProfiles().stream().filter(profile -> sortedActiveProfiles.contains(profile.getId())).map(profile -> this.findArtifactPackagerPlugin(profile.getBuild() != null ? profile.getBuild().getPlugins() : null)).filter(plugin -> !plugin.equals(Optional.empty())).map(Optional::get);
        return Stream.concat(basePlugin, packagerConfigsForActivePluginsStream).reduce((p1, p2) -> {
            p1.setConfiguration((Object)Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)p2.getConfiguration()), (Xpp3Dom)((Xpp3Dom)p1.getConfiguration())));
            p1.getDependencies().addAll(p2.getDependencies());
            return p1;
        });
    }

    private Optional<Plugin> findArtifactPackagerPlugin(List<Plugin> plugins) {
        if (plugins != null) {
            return plugins.stream().filter(plugin -> plugin.getArtifactId().equals("mule-maven-plugin") && plugin.getGroupId().equals("org.mule.tools.maven") || plugin.getArtifactId().equals("mule-extensions-maven-plugin") && plugin.getGroupId().equals("org.mule.runtime.plugins")).findFirst();
        }
        return Optional.empty();
    }

    private List<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin> getAdditionalPluginDependencies(Plugin packagingPlugin) {
        Xpp3Dom[] pluginsDom;
        Xpp3Dom additionalPluginDependenciesDom;
        ArrayList<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin> pluginsAdditionalLibraries = new ArrayList<org.mule.runtime.module.artifact.activation.internal.plugin.Plugin>();
        Object configuration = packagingPlugin.getConfiguration();
        if (configuration != null && (additionalPluginDependenciesDom = ((Xpp3Dom)configuration).getChild("additionalPluginDependencies")) != null && (pluginsDom = additionalPluginDependenciesDom.getChildren("plugin")) != null) {
            for (Xpp3Dom pluginDom : pluginsDom) {
                String pluginGroupId = this.getChildParameterValue(pluginDom, GROUP_ID, true);
                String pluginArtifactId = this.getChildParameterValue(pluginDom, ARTIFACT_ID, true);
                ArrayList<Dependency> additionalDependencyDependencies = new ArrayList<Dependency>();
                Xpp3Dom dependenciesDom = pluginDom.getChild("additionalDependencies");
                if (dependenciesDom != null) {
                    for (Xpp3Dom dependencyDom : dependenciesDom.getChildren("dependency")) {
                        Dependency dependency = new Dependency();
                        dependency.setGroupId(this.getChildParameterValue(dependencyDom, GROUP_ID, true));
                        dependency.setArtifactId(this.getChildParameterValue(dependencyDom, ARTIFACT_ID, true));
                        dependency.setVersion(this.getChildParameterValue(dependencyDom, VERSION, true));
                        String type = this.getChildParameterValue(dependencyDom, "type", false);
                        dependency.setType(type == null ? "jar" : type);
                        dependency.setClassifier(this.getChildParameterValue(dependencyDom, "classifier", false));
                        dependency.setSystemPath(this.getChildParameterValue(dependencyDom, "systemPath", false));
                        additionalDependencyDependencies.add(dependency);
                    }
                }
                org.mule.runtime.module.artifact.activation.internal.plugin.Plugin plugin = new org.mule.runtime.module.artifact.activation.internal.plugin.Plugin();
                plugin.setGroupId(pluginGroupId);
                plugin.setArtifactId(pluginArtifactId);
                plugin.setAdditionalDependencies(additionalDependencyDependencies);
                pluginsAdditionalLibraries.add(plugin);
            }
        }
        return pluginsAdditionalLibraries;
    }

    private String getChildParameterValue(Xpp3Dom element, String childName, boolean validate) {
        String childValue;
        Xpp3Dom child = element.getChild(childName);
        String string = childValue = child != null ? child.getValue() : null;
        if (StringUtils.isEmpty((CharSequence)childValue) && validate) {
            throw new IllegalArgumentException("Expecting child element with not null value " + childName);
        }
        return childValue;
    }
}

