/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.util.MavenUtils;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.maven.AbstractMavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class LightweightDeployableProjectModelBuilder
extends AbstractMavenDeployableProjectModelBuilder {
    private final boolean isDomain;
    private final File projectFolder;
    private final Optional<MuleDeployableModel> model;

    public LightweightDeployableProjectModelBuilder(File projectFolder, boolean isDomain) {
        this(projectFolder, Optional.empty(), isDomain);
    }

    public LightweightDeployableProjectModelBuilder(File projectFolder, Optional<MuleDeployableModel> model, boolean isDomain) {
        super(GlobalConfigLoader.getMavenConfig());
        this.projectFolder = projectFolder;
        this.model = model;
        this.isDomain = isDomain;
    }

    @Override
    public DeployableProjectModel build() {
        File pom = this.getPomFromFolder(this.projectFolder);
        Model pomModel = MavenUtils.getPomModelFromFile((File)pom);
        this.deployableArtifactRepositoryFolder = this.mavenConfiguration.getLocalMavenRepositoryLocation();
        ArtifactCoordinates deployableArtifactCoordinates = this.getDeployableProjectArtifactCoordinates(pomModel);
        AetherMavenClient aetherMavenClient = new AetherMavenClient(this.mavenConfiguration);
        List<String> activeProfiles = this.mavenConfiguration.getActiveProfiles().orElse(Collections.emptyList());
        this.resolveDeployableDependencies(aetherMavenClient, pom, pomModel, activeProfiles);
        this.resolveDeployablePluginsData(this.deployableMavenBundleDependencies);
        this.resolveAdditionalPluginDependencies(aetherMavenClient, pomModel, activeProfiles, this.pluginsArtifactDependencies);
        Supplier<MuleDeployableModel> modelResolver = this.getModelResolver();
        List<String> exportedPackages = modelResolver.get().getClassLoaderModelLoaderDescriptor().getAttributes().getOrDefault("exportedPackages", Collections.emptyList());
        List<String> exportedResources = modelResolver.get().getClassLoaderModelLoaderDescriptor().getAttributes().getOrDefault("exportedResources", Collections.emptyList());
        return new DeployableProjectModel(exportedPackages, exportedResources, Collections.emptyList(), this.buildBundleDescriptor(deployableArtifactCoordinates, this.isDomain), modelResolver, this.projectFolder, this.deployableBundleDependencies, this.sharedDeployableBundleDescriptors, this.additionalPluginDependencies);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getPomFromFolder(File projectFolder) {
        File mavenFolder = new File(projectFolder, "META-INF/maven");
        try (Stream<Path> stream = Files.find(mavenFolder.toPath(), 3, (p, m) -> p.getFileName().toString().equals("pom.xml"), new FileVisitOption[0]);){
            List pomLists = stream.collect(Collectors.toList());
            if (pomLists.size() != 1) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could find the pom in " + mavenFolder.toPath())));
            }
            File file = ((Path)pomLists.get(0)).toFile();
            return file;
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Supplier<MuleDeployableModel> getModelResolver() {
        return () -> this.model.orElseGet(() -> {
            if (this.isDomain) {
                return ArtifactModelResolver.domainModelResolver().resolve(new File(this.projectFolder, "META-INF/mule-artifact"));
            }
            return ArtifactModelResolver.applicationModelResolver().resolve(new File(this.projectFolder, "META-INF/mule-artifact"));
        });
    }

    private BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates, boolean isDomain) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType(artifactCoordinates.getType()).setClassifier(isDomain ? "mule-domain" : "mule-application").build();
    }
}

