/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.util.MavenUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.maven.AbstractMavenDeployableProjectModelBuilder;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class MavenDeployableProjectModelBuilder
extends AbstractMavenDeployableProjectModelBuilder {
    private final File projectFolder;
    private List<String> packages = Collections.emptyList();
    private List<String> resources = Collections.emptyList();
    private final List<Path> resourcesPath = new ArrayList<Path>();
    private boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor = false;

    public MavenDeployableProjectModelBuilder(File projectFolder, MavenConfiguration mavenConfiguration, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor) {
        super(mavenConfiguration);
        this.projectFolder = projectFolder;
        this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor = exportAllResourcesAndPackagesIfEmptyLoaderDescriptor;
    }

    public MavenDeployableProjectModelBuilder(File projectFolder, MavenConfiguration mavenConfiguration) {
        super(mavenConfiguration);
        this.projectFolder = projectFolder;
    }

    public MavenDeployableProjectModelBuilder(File projectFolder, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration(), exportAllResourcesAndPackagesIfEmptyLoaderDescriptor);
    }

    public MavenDeployableProjectModelBuilder(File projectFolder) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration());
    }

    protected static MavenConfiguration getDefaultMavenConfiguration() {
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)MavenDeployableProjectModelBuilder.class.getClassLoader());
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation((File)localMavenRepository.get());
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    @Override
    public DeployableProjectModel build() {
        File pom = this.getPomFromFolder(this.projectFolder);
        Model pomModel = MavenUtils.getPomModelFromFile((File)pom);
        this.deployableArtifactRepositoryFolder = this.mavenConfiguration.getLocalMavenRepositoryLocation();
        ArtifactCoordinates deployableArtifactCoordinates = this.getDeployableProjectArtifactCoordinates(pomModel);
        AetherMavenClient aetherMavenClient = new AetherMavenClient(this.mavenConfiguration);
        List<String> activeProfiles = this.mavenConfiguration.getActiveProfiles().orElse(Collections.emptyList());
        this.resolveDeployableDependencies(aetherMavenClient, pom, pomModel, activeProfiles);
        this.resolveDeployablePluginsData(this.deployableMavenBundleDependencies);
        this.resolveAdditionalPluginDependencies(aetherMavenClient, pomModel, activeProfiles, this.pluginsArtifactDependencies);
        try {
            this.getAvailablePackagesAndResources(pomModel.getBuild());
        }
        catch (IOException e) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)"Couldn't search exported packages and resources"), e);
        }
        return new DeployableProjectModel(this.packages, this.resources, this.resourcesPath, this.buildBundleDescriptor(deployableArtifactCoordinates), this.getModelResolver(deployableArtifactCoordinates), this.projectFolder, this.deployableBundleDependencies, this.sharedDeployableBundleDescriptors, this.additionalPluginDependencies);
    }

    private Supplier<MuleDeployableModel> getModelResolver(ArtifactCoordinates deployableArtifactCoordinates) {
        if (deployableArtifactCoordinates.getClassifier().equals("mule-application")) {
            return () -> {
                MuleApplicationModel applicationModel = ArtifactModelResolver.applicationModelResolver().resolve(this.projectFolder);
                if (this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor && applicationModel.getClassLoaderModelLoaderDescriptor() == null) {
                    applicationModel = this.buildModelWithResourcesAndClasses(applicationModel);
                }
                return applicationModel;
            };
        }
        if (deployableArtifactCoordinates.getClassifier().equals("mule-domain")) {
            return () -> ArtifactModelResolver.domainModelResolver().resolve(this.projectFolder);
        }
        throw new IllegalStateException("project is not a mule-application or mule-domain");
    }

    private MuleApplicationModel buildModelWithResourcesAndClasses(MuleApplicationModel applicationModel) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = ((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)new MuleApplicationModel.MuleApplicationModelBuilder().setName(applicationModel.getName() != null ? applicationModel.getName() : "mule")).setMinMuleVersion(applicationModel.getMinMuleVersion())).setRequiredProduct(applicationModel.getRequiredProduct())).withClassLoaderModelDescriptorLoader(this.createDescriptorWithResourcesAndClasses())).withBundleDescriptorLoader(applicationModel.getBundleDescriptorLoader() != null ? applicationModel.getBundleDescriptorLoader() : new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).setDomain((String)applicationModel.getDomain().orElse(null));
        builder.setConfigs(applicationModel.getConfigs());
        builder.setRedeploymentEnabled(applicationModel.isRedeploymentEnabled());
        builder.setSecureProperties(applicationModel.getSecureProperties());
        builder.setLogConfigFile(applicationModel.getLogConfigFile());
        return (MuleApplicationModel)builder.build();
    }

    private MuleArtifactLoaderDescriptor createDescriptorWithResourcesAndClasses() {
        ImmutableMap attributes = ImmutableMap.of((Object)"exportedResources", this.resources, (Object)"exportedPackages", this.packages);
        return new MuleArtifactLoaderDescriptor("mule", (Map)attributes);
    }

    private void getAvailablePackagesAndResources(Build build) throws IOException {
        String sourceDirectory = build.getSourceDirectory() != null ? build.getSourceDirectory() : "src/main";
        Path javaDirectory = Paths.get(this.projectFolder.getAbsolutePath(), sourceDirectory.concat("/java"));
        List allJavaFiles = Files.walk(javaDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        Predicate<Path> isJavaFile = path -> FilenameUtils.getExtension((String)path.toString()).endsWith("java");
        this.packages = allJavaFiles.stream().filter(isJavaFile).map(path -> {
            Path parent = javaDirectory.relativize((Path)path).getParent();
            return parent != null ? parent.toString() : "";
        }).map(this::escapeSlashes).map(s -> s.replace("/", ".")).distinct().collect(Collectors.toList());
        this.resources = build.getResources().isEmpty() ? this.getResourcesInFolder(sourceDirectory.concat("/resources")) : build.getResources().stream().flatMap(r -> {
            try {
                return this.getResourcesInFolder(r.getDirectory()).stream();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load files from" + r.getDirectory());
            }
        }).collect(Collectors.toList());
        this.resources.addAll(this.getResourcesInFolder(sourceDirectory.concat("/mule")));
    }

    private List<String> getResourcesInFolder(String resourcesDirectoryName) throws IOException {
        Path resourcesDirectory = Paths.get(this.projectFolder.getAbsolutePath(), resourcesDirectoryName);
        this.resourcesPath.add(resourcesDirectory);
        List allResourcesFiles = Files.walk(resourcesDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        return allResourcesFiles.stream().map(resourcesDirectory::relativize).map(Path::toString).map(this::escapeSlashes).collect(Collectors.toList());
    }

    private String escapeSlashes(String p) {
        return p.replace("\\", "/");
    }

    private File getPomFromFolder(File projectFolder) {
        String pomFilePath = "pom.xml";
        File pomFile = new File(projectFolder, pomFilePath);
        Preconditions.checkState((boolean)pomFile.exists(), (String)String.format("The pom.xml file for artifact in folder %s could not be found", projectFolder.getAbsolutePath()));
        return pomFile;
    }
}

