/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.plugin;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.module.artifact.activation.internal.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.internal.plugin.PluginClassLoaderConfigurationAssembler;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.plugin.LoaderDescriber;

public class ArtifactPluginDescriptorFactory
extends AbstractArtifactDescriptorFactory<MulePluginModel, ArtifactPluginDescriptor> {
    private final MulePluginModel pluginModel;
    private final BundleDependency bundleDependency;
    private final DeployableArtifactDescriptor ownerDescriptor;
    private final List<BundleDependency> bundleDependencies;
    private final Set<BundleDescriptor> sharedProjectDependencies;

    public ArtifactPluginDescriptorFactory(BundleDependency bundleDependency, MulePluginModel pluginModel, DeployableArtifactDescriptor ownerDescriptor, List<BundleDependency> bundleDependencies, Set<BundleDescriptor> sharedProjectDependencies, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(new File(bundleDependency.getBundleUri()), artifactDescriptorValidatorBuilder);
        this.pluginModel = pluginModel;
        this.bundleDependency = bundleDependency;
        this.ownerDescriptor = ownerDescriptor;
        this.bundleDependencies = bundleDependencies;
        this.sharedProjectDependencies = sharedProjectDependencies;
    }

    @Override
    protected MulePluginModel createArtifactModel() {
        return this.pluginModel;
    }

    @Override
    protected void doDescriptorConfig(ArtifactPluginDescriptor descriptor) {
        ((MulePluginModel)this.getArtifactModel()).getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptor -> {
            LoaderDescriber loaderDescriber = new LoaderDescriber(extensionModelDescriptor.getId());
            loaderDescriber.addAttributes(extensionModelDescriptor.getAttributes());
            descriptor.setExtensionModelDescriptorProperty(loaderDescriber);
        });
        ((MulePluginModel)this.getArtifactModel()).getLicense().ifPresent(arg_0 -> ((ArtifactPluginDescriptor)descriptor).setLicenseModel(arg_0));
    }

    @Override
    protected ClassLoaderConfiguration getClassLoaderConfiguration(MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
        return new PluginClassLoaderConfigurationAssembler(this.bundleDependency, this.sharedProjectDependencies, this.getArtifactLocation(), muleArtifactLoaderDescriptor, this.bundleDependencies, this.ownerDescriptor).createClassLoaderConfiguration();
    }

    @Override
    protected BundleDescriptor getBundleDescriptor() {
        return this.bundleDependency.getDescriptor();
    }

    @Override
    protected ArtifactPluginDescriptor doCreateArtifactDescriptor() {
        return new ArtifactPluginDescriptor(((MulePluginModel)this.getArtifactModel()).getName(), Optional.empty());
    }
}

