/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonDeserializingArtifactModelResolver<M extends MuleDeployableModel>
implements ArtifactModelResolver<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDeserializingArtifactModelResolver.class);
    private final AbstractMuleArtifactModelJsonSerializer<M> jsonDeserializer;

    public JsonDeserializingArtifactModelResolver(AbstractMuleArtifactModelJsonSerializer<M> jsonDeserializer) {
        this.jsonDeserializer = jsonDeserializer;
    }

    @Override
    public M resolve(File artifactLocation) {
        File artifactJsonFile = new File(artifactLocation, "mule-artifact.json");
        if (!artifactJsonFile.exists()) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)("Couldn't find model file " + artifactJsonFile)));
        }
        return this.loadModelFromJson(this.getDescriptorContent(artifactJsonFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDescriptorContent(File jsonFile) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading artifact descriptor from '{}'..." + jsonFile.getAbsolutePath());
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(jsonFile));){
            String string = IOUtils.toString((InputStream)stream);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read extension describer on artifact '%s'", jsonFile.getAbsolutePath()), e);
        }
    }

    private M loadModelFromJson(String jsonString) {
        try {
            return this.deserializeArtifactModel(jsonString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot deserialize artifact descriptor from: " + jsonString);
        }
    }

    private M deserializeArtifactModel(String jsonString) throws IOException {
        return (M)((MuleDeployableModel)this.getMuleArtifactModelJsonSerializer().deserialize(jsonString));
    }

    private AbstractMuleArtifactModelJsonSerializer<M> getMuleArtifactModelJsonSerializer() {
        return this.jsonDeserializer;
    }
}

