/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.serializer;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;

public class ArtifactClassLoaderObjectOutputStream
extends ObjectOutputStream {
    private final ClassLoaderRepository classLoaderRepository;

    public ArtifactClassLoaderObjectOutputStream(ClassLoaderRepository classLoaderRepository, OutputStream out) throws IOException {
        super(out);
        this.classLoaderRepository = classLoaderRepository;
    }

    @Override
    protected void annotateClass(Class<?> clazz) throws IOException {
        Optional<String> id = this.classLoaderRepository.getId(clazz.getClassLoader());
        if (id.isPresent()) {
            this.writeInt(id.get().length());
            this.writeBytes(id.get());
        } else {
            this.writeInt(-1);
        }
    }
}

