/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;

public class ClassLoaderModel {
    public static final ClassLoaderModel NULL_CLASSLOADER_MODEL = new ClassLoaderModel(new URL[0], new HashSet<String>(), new HashSet<String>(), new HashSet<BundleDependency>(), new HashSet<String>(), new HashSet<String>(), false);
    private final URL[] urls;
    private final Set<String> exportedPackages;
    private final Set<String> exportedResources;
    private final Set<BundleDependency> dependencies;
    private final Set<String> privilegedExportedPackages;
    private final Set<String> privilegedArtifacts;
    private final boolean includeTestDependencies;

    private ClassLoaderModel(URL[] urls, Set<String> exportedPackages, Set<String> exportedResources, Set<BundleDependency> dependencies, Set<String> privilegedExportedPackages, Set<String> privilegedArtifacts, boolean includeTestDependencies) {
        this.urls = urls;
        this.exportedPackages = exportedPackages;
        this.exportedResources = exportedResources;
        this.dependencies = dependencies;
        this.privilegedExportedPackages = privilegedExportedPackages;
        this.privilegedArtifacts = privilegedArtifacts;
        this.includeTestDependencies = includeTestDependencies;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public Set<String> getExportedResources() {
        return this.exportedResources;
    }

    public Set<BundleDependency> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getPrivilegedExportedPackages() {
        return this.privilegedExportedPackages;
    }

    public Set<String> getPrivilegedArtifacts() {
        return this.privilegedArtifacts;
    }

    public boolean isIncludeTestDependencies() {
        return this.includeTestDependencies;
    }

    public static class ClassLoaderModelBuilder {
        private Set<String> packages = new HashSet<String>();
        private Set<String> resources = new HashSet<String>();
        private List<URL> urls = new ArrayList<URL>();
        private Set<BundleDependency> dependencies = new HashSet<BundleDependency>();
        private Set<String> privilegedExportedPackages = new HashSet<String>();
        private Set<String> privilegedArtifacts = new HashSet<String>();
        private Boolean includeTestDependencies = Boolean.FALSE;

        public ClassLoaderModelBuilder() {
        }

        public ClassLoaderModelBuilder(ClassLoaderModel source) {
            Preconditions.checkArgument((source != null ? 1 : 0) != 0, (String)"source cannot be null");
            this.packages.addAll(source.exportedPackages);
            this.resources.addAll(source.exportedResources);
            this.urls = new ArrayList<URL>(Arrays.asList(source.urls));
            this.dependencies.addAll(source.dependencies);
            this.privilegedExportedPackages.addAll(source.privilegedExportedPackages);
            this.privilegedArtifacts.addAll(source.privilegedArtifacts);
        }

        public ClassLoaderModelBuilder exportingPackages(Set<String> packages) {
            Preconditions.checkArgument((packages != null ? 1 : 0) != 0, (String)"packages cannot be null");
            this.packages.addAll(packages);
            return this;
        }

        public ClassLoaderModelBuilder exportingResources(Set<String> resources) {
            Preconditions.checkArgument((resources != null ? 1 : 0) != 0, (String)"resources cannot be null");
            this.resources.addAll(resources);
            return this;
        }

        public ClassLoaderModelBuilder exportingPrivilegedPackages(Set<String> packages, Set<String> artifactIds) {
            Preconditions.checkArgument((packages != null ? 1 : 0) != 0, (String)"packages cannot be null");
            Preconditions.checkArgument((artifactIds != null ? 1 : 0) != 0, (String)"artifactIds cannot be null");
            Preconditions.checkArgument((packages.isEmpty() == artifactIds.isEmpty() ? 1 : 0) != 0, (String)"Both packages and artifactIds must be empty or non empty simultaneously");
            this.privilegedExportedPackages.addAll(packages);
            this.privilegedArtifacts.addAll(artifactIds);
            return this;
        }

        public ClassLoaderModelBuilder dependingOn(Set<BundleDependency> dependencies) {
            Preconditions.checkArgument((dependencies != null ? 1 : 0) != 0, (String)"dependencies cannot be null");
            this.dependencies.addAll(dependencies);
            return this;
        }

        public ClassLoaderModelBuilder containing(URL url) {
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"url cannot be null");
            this.urls.add(url);
            return this;
        }

        public ClassLoaderModelBuilder includeTestDependencies(boolean includeTestDependencies) {
            this.includeTestDependencies = includeTestDependencies;
            return this;
        }

        public ClassLoaderModel build() {
            return new ClassLoaderModel(this.urls.toArray(new URL[0]), this.packages, this.resources, this.dependencies, this.privilegedExportedPackages, this.privilegedArtifacts, this.includeTestDependencies);
        }
    }
}

