/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.LocalResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.exception.ClassNotFoundInRegionException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.CompoundEnumeration;

public class RegionClassLoader
extends MuleDeployableArtifactClassLoader {
    protected static final String REGION_OWNER_CANNOT_BE_REMOVED_ERROR = "Region owner cannot be removed";
    private static final Logger LOGGER;
    private final ReadWriteLock innerStateRWLock = new ReentrantReadWriteLock();
    private final Lock innerStateReadLock = this.innerStateRWLock.readLock();
    private final Lock innerStateWriteLock = this.innerStateRWLock.writeLock();
    private final List<RegionMemberClassLoader> registeredClassLoaders = new ArrayList<RegionMemberClassLoader>();
    private final Map<String, ArtifactClassLoader> packageMapping = new HashMap<String, ArtifactClassLoader>();
    private final Map<String, List<ArtifactClassLoader>> resourceMapping = new HashMap<String, List<ArtifactClassLoader>>();
    private ArtifactClassLoader ownerClassLoader;

    public RegionClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(artifactId, artifactDescriptor, new URL[0], parent, lookupPolicy, Collections.emptyList());
    }

    @Override
    public List<ArtifactClassLoader> getArtifactPluginClassLoaders() {
        return this.registeredClassLoaders.stream().map(r -> r.unfilteredClassLoader).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassLoader(ArtifactClassLoader artifactClassLoader, ArtifactClassLoaderFilter filter) {
        Preconditions.checkArgument((artifactClassLoader != null ? 1 : 0) != 0, (String)"artifactClassLoader cannot be null");
        Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (String)"filter cannot be null");
        this.innerStateWriteLock.lock();
        try {
            RegionMemberClassLoader registeredClassLoader = this.findRegisteredClassLoader(artifactClassLoader);
            if (artifactClassLoader == this.ownerClassLoader || registeredClassLoader != null) {
                throw new IllegalArgumentException(RegionClassLoader.createClassLoaderAlreadyInRegionError(artifactClassLoader.getArtifactId()));
            }
            if (this.ownerClassLoader == null) {
                this.ownerClassLoader = artifactClassLoader;
            } else {
                this.registeredClassLoaders.add(new RegionMemberClassLoader(artifactClassLoader, filter));
            }
            filter.getExportedClassPackages().forEach(p -> {
                LookupStrategy packageLookupStrategy = this.getClassLoaderLookupPolicy().getPackageLookupStrategy((String)p);
                if (!(packageLookupStrategy instanceof ChildFirstLookupStrategy)) {
                    throw new IllegalStateException(RegionClassLoader.illegalPackageMappingError(p, packageLookupStrategy));
                }
                if (this.packageMapping.containsKey(p)) {
                    throw new IllegalStateException(RegionClassLoader.duplicatePackageMappingError(p, this.packageMapping.get(p), artifactClassLoader));
                }
                this.packageMapping.put((String)p, artifactClassLoader);
            });
            for (String exportedResource : filter.getExportedResources()) {
                List<ArtifactClassLoader> classLoaders = this.resourceMapping.get(exportedResource);
                if (classLoaders == null) {
                    classLoaders = new ArrayList<ArtifactClassLoader>();
                    this.resourceMapping.put(exportedResource, classLoaders);
                }
                classLoaders.add(artifactClassLoader);
            }
        }
        finally {
            this.innerStateWriteLock.unlock();
        }
    }

    static String illegalPackageMappingError(String p, LookupStrategy packageLookupStrategy) {
        return String.format("Attempt to map package '%s' which was already defined on the region lookup policy with '%s'", p, packageLookupStrategy.getClass().getName());
    }

    static String duplicatePackageMappingError(String packageName, ArtifactClassLoader originalDefinitionClassLoader, ArtifactClassLoader overridingDefinitionClassLoader) {
        return String.format("Attempt to redefine mapping for package: '%s'. Original definition classloader is %s, Overriding definition classloader is %s", packageName, originalDefinitionClassLoader.toString(), overridingDefinitionClassLoader.toString());
    }

    private RegionMemberClassLoader findRegisteredClassLoader(ArtifactClassLoader artifactClassLoader) {
        for (RegionMemberClassLoader registeredClassLoader : this.registeredClassLoaders) {
            if (registeredClassLoader.unfilteredClassLoader != artifactClassLoader) continue;
            return registeredClassLoader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeClassLoader(ArtifactClassLoader artifactClassLoader) {
        Preconditions.checkArgument((artifactClassLoader != null ? 1 : 0) != 0, (String)"artifactClassLoader cannot be null");
        if (this.ownerClassLoader == artifactClassLoader) {
            throw new IllegalArgumentException(REGION_OWNER_CANNOT_BE_REMOVED_ERROR);
        }
        this.innerStateWriteLock.lock();
        try {
            RegionMemberClassLoader registeredClassLoader = this.findRegisteredClassLoader(artifactClassLoader);
            int index = this.registeredClassLoaders.indexOf(registeredClassLoader);
            if (index < 0) {
                boolean bl = false;
                return bl;
            }
            if (!registeredClassLoader.filter.getExportedClassPackages().isEmpty() || !registeredClassLoader.filter.getExportedResources().isEmpty()) {
                throw new IllegalArgumentException(RegionClassLoader.createCannotRemoveClassLoaderError(artifactClassLoader.getArtifactId()));
            }
            this.registeredClassLoaders.remove(index);
            boolean bl = true;
            return bl;
        }
        finally {
            this.innerStateWriteLock.unlock();
        }
    }

    @Override
    public Class<?> findLocalClass(String name) throws ClassNotFoundException {
        this.innerStateReadLock.lock();
        try {
            String packageName = ClassUtils.getPackageName((String)name);
            ArtifactClassLoader artifactClassLoader = this.packageMapping.get(packageName);
            if (artifactClassLoader != null) {
                try {
                    Class<?> clazz = artifactClassLoader.findLocalClass(name);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundInRegionException(name, this.getArtifactId(), artifactClassLoader.getArtifactId(), e);
                }
            }
            throw new ClassNotFoundInRegionException(name, this.getArtifactId());
        }
        finally {
            this.innerStateReadLock.unlock();
        }
    }

    @Override
    public final URL findResource(String name) {
        URL resource;
        block1: {
            ArtifactClassLoader artifactClassLoader;
            resource = null;
            List<ArtifactClassLoader> artifactClassLoaders = this.resourceMapping.get(name);
            if (artifactClassLoaders == null) break block1;
            Iterator<ArtifactClassLoader> iterator = artifactClassLoaders.iterator();
            while (iterator.hasNext() && (resource = (artifactClassLoader = iterator.next()).findResource(name)) == null) {
            }
        }
        return resource;
    }

    @Override
    public final Enumeration<URL> findResources(String name) throws IOException {
        List<ArtifactClassLoader> artifactClassLoaders = this.resourceMapping.get(name);
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>(this.registeredClassLoaders.size());
        if (artifactClassLoaders != null) {
            for (ArtifactClassLoader artifactClassLoader : artifactClassLoaders) {
                Enumeration<URL> partialResources = artifactClassLoader.findResources(name);
                if (!partialResources.hasMoreElements()) continue;
                enumerations.add(partialResources);
            }
        }
        return new CompoundEnumeration(enumerations.toArray(new Enumeration[0]));
    }

    @Override
    public void dispose() {
        this.registeredClassLoaders.stream().map(c -> c.unfilteredClassLoader).forEach(classLoader -> this.disposeClassLoader((ArtifactClassLoader)classLoader));
        this.registeredClassLoaders.clear();
        this.disposeClassLoader(this.ownerClassLoader);
        super.dispose();
    }

    private void disposeClassLoader(ArtifactClassLoader classLoader) {
        try {
            classLoader.dispose();
        }
        catch (Exception e) {
            String message = "Error disposing classloader for '{}'. This can cause a memory leak";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error disposing classloader for '{}'. This can cause a memory leak", (Object)classLoader.getArtifactId(), (Object)e);
            }
            LOGGER.error("Error disposing classloader for '{}'. This can cause a memory leak", (Object)classLoader.getArtifactId());
        }
    }

    @Override
    public URL findLocalResource(String resourceName) {
        URL resource = this.getOwnerClassLoader().findLocalResource(resourceName);
        if (resource == null && this.getParent() instanceof LocalResourceLocator) {
            resource = ((LocalResourceLocator)((Object)this.getParent())).findLocalResource(resourceName);
        }
        return resource;
    }

    private ArtifactClassLoader getOwnerClassLoader() {
        return this.ownerClassLoader;
    }

    @Override
    public String toString() {
        return String.format("%s[%s] -> %s@%s", this.getClass().getName(), this.getArtifactId(), this.packageMapping.toString(), Integer.toHexString(System.identityHashCode(this)));
    }

    static String createCannotRemoveClassLoaderError(String artifactId) {
        return String.format("Cannot remove classloader '%s' as it exports at least a package or resource", artifactId);
    }

    static String createClassLoaderAlreadyInRegionError(String artifactId) {
        return "Region already contains classloader for artifact:" + artifactId;
    }

    static {
        RegionClassLoader.registerAsParallelCapable();
        LOGGER = LoggerFactory.getLogger(RegionClassLoader.class);
    }

    private static class RegionMemberClassLoader {
        final ArtifactClassLoader unfilteredClassLoader;
        final ArtifactClassLoaderFilter filter;

        private RegionMemberClassLoader(ArtifactClassLoader unfilteredClassLoader, ArtifactClassLoaderFilter filter) {
            this.unfilteredClassLoader = unfilteredClassLoader;
            this.filter = filter;
        }
    }
}

