/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.api.classloader.LocalResourceLocator;

public class DirectoryResourceLocator
implements LocalResourceLocator {
    private String[] directories;

    public DirectoryResourceLocator(String ... directories) {
        this.directories = directories;
    }

    @Override
    public URL findLocalResource(String resourceName) {
        if (this.directories != null && resourceName != null) {
            for (String directory : this.directories) {
                File resourceFile = new File(directory, resourceName);
                if (!resourceFile.exists()) continue;
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Can not load resource with name %s.", resourceName)), (Throwable)e);
                }
            }
        }
        return null;
    }
}

