/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader.exception;

import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
public final class NotExportedClassException
extends ClassNotFoundException {
    private static final Logger logger = LoggerFactory.getLogger(NotExportedClassException.class);
    private static final long serialVersionUID = 2510347069070514572L;
    private final String className;
    private final String artifactName;
    private final ClassLoaderFilter filter;

    public NotExportedClassException(String className, String artifactName, ClassLoaderFilter filter) {
        super(String.format("Class '%s' not found in classloader for artifact '%s'.", className, artifactName));
        this.className = className;
        this.artifactName = artifactName;
        this.filter = filter;
    }

    public String getClassName() {
        return this.className;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public ClassLoaderFilter getFilter() {
        return this.filter;
    }

    @Override
    public String getMessage() {
        if (Boolean.valueOf(System.getProperty("mule.classloading.verbose")).booleanValue() && logger.isTraceEnabled()) {
            return super.getMessage() + System.lineSeparator() + this.filter.toString();
        }
        return super.getMessage();
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        if (Boolean.getBoolean("mule.verbose.exceptions")) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

