/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.util.test;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;

public enum DeploymentTestingFeatures implements Feature
{
    ALWAYS_ON_FEATURE("Testing feature", "MULE-123", "4.4.0"),
    OVERRIDEABLE_FEATURE("Testing feature", "MULE-123", "4.4.0", "overrideable.feature.override");

    private static final AtomicBoolean areFeatureFlagsConfigured;
    public static final String OVERRIDEABLE_FEATURE_OVERRIDE = "overrideable.feature.override";
    private final String description;
    private final String issue;
    private final String enabledByDefaultSince;
    private final String overridingSystemPropertyName;

    private DeploymentTestingFeatures(String description, String issue, String enabledByDefaultSince) {
        this(description, issue, enabledByDefaultSince, null);
    }

    private DeploymentTestingFeatures(String description, String issue, String enabledByDefaultSince, String overridingSystemPropertyName) {
        this.description = description;
        this.issue = issue;
        this.enabledByDefaultSince = enabledByDefaultSince;
        this.overridingSystemPropertyName = overridingSystemPropertyName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIssueId() {
        return this.issue;
    }

    public String getSince() {
        return this.getEnabledByDefaultSince();
    }

    public String getEnabledByDefaultSince() {
        return this.enabledByDefaultSince;
    }

    public Optional<String> getOverridingSystemPropertyName() {
        return Optional.ofNullable(this.overridingSystemPropertyName);
    }

    static {
        areFeatureFlagsConfigured = new AtomicBoolean();
        if (!areFeatureFlagsConfigured.getAndSet(true)) {
            FeatureFlaggingRegistry.getInstance().registerFeatureFlag((Feature)ALWAYS_ON_FEATURE, featureContext -> true);
            FeatureFlaggingRegistry.getInstance().registerFeatureFlag((Feature)OVERRIDEABLE_FEATURE, featureContext -> false);
        }
    }
}

